/*
 * bltBind.h --
 *
 * Copyright 1993-1998 Lucent Technologies, Inc.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby
 * granted, provided that the above copyright notice appear in all
 * copies and that both that the copyright notice and warranty
 * disclaimer appear in supporting documentation, and that the names
 * of Lucent Technologies any of their entities not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 *
 * Lucent Technologies disclaims all warranties with regard to this
 * software, including all implied warranties of merchantability and
 * fitness.  In no event shall Lucent Technologies be liable for any
 * special, indirect or consequential damages or any damages
 * whatsoever resulting from loss of use, data or profits, whether in
 * an action of contract, negligence or other tortuous action, arising
 * out of or in connection with the use or performance of this
 * software.
 */

#ifndef _BLT_BIND_H
#define _BLT_BIND_H

typedef struct BindTableRec *BindTable;

typedef struct {
    ClientData object;
    int type;
} BindObject;

typedef ClientData (BindPickProc) _ANSI_ARGS_((ClientData clientData,
	int x, int y));

typedef void (BindTagProc) _ANSI_ARGS_((BindTable bindTable, ClientData object,
	ClientData *tagArr, int *nTagsPtr));

/*
 *  Binding structure information:
 */

struct BindTableRec {
    int flags;
    Tk_BindingTable bindingTable;
				/* Table of all bindings currently defined.
				 * NULL means that no bindings exist, so the
				 * table hasn't been created.  Each "object"
				 * used for this table is either a Tk_Uid for
				 * a tag or the address of an item named by
				 * id. */

    ClientData currentItem;	/* The item currently containing the mouse
				 * pointer, or NULL if none. */

    ClientData newItem;		/* The item that is about to become the
				 * current one, or NULL.  This field is
				 * used to detect deletions of the new
				 * current item pointer that occur during
				 * Leave processing of the previous current
				 * tab.  */

    ClientData focusItem;

    XEvent pickEvent;		/* The event upon which the current choice
				 * of the current tab is based.  Must be saved
				 * so that if the current item is deleted,
				 * we can pick another. */
    int activePick;		/* The pick event has been initialized so
				 * that we can repick it */

    int state;			/* Last known modifier state.  Used to
				 * defer picking a new current object
				 * while buttons are down. */

    ClientData clientData;
    Tk_Window tkwin;
    BindPickProc *pickProc;	/* Routine to report the item the mouse is
				 * currently over. */
    BindTagProc *tagProc;	/* Routine to report tags picked items. */
};

extern void Blt_DestroyBindingTable _ANSI_ARGS_((BindTable table));

extern BindTable Blt_CreateBindingTable _ANSI_ARGS_((Tcl_Interp *interp,
	Tk_Window tkwin, ClientData clientData, BindPickProc * pickProc,
	BindTagProc * tagProc));

extern int Blt_ConfigureBindings _ANSI_ARGS_((Tcl_Interp *interp,
	BindTable table, ClientData item, int argc, char **argv));

extern void Blt_PickCurrentItem _ANSI_ARGS_((BindTable table));

extern void Blt_DeleteBindings _ANSI_ARGS_((BindTable table,
	ClientData object));

#define Blt_SetFocusItem(bindPtr, object) \
	((bindPtr)->focusItem = (ClientData)(object))
#define Blt_SetCurrentItem(bindPtr, object) \
	((bindPtr)->currentItem = (ClientData)(object))

#define Blt_GetCurrentItem(bindPtr)  ((bindPtr)->currentItem)
#define Blt_GetLatestItem(bindPtr)  ((bindPtr)->newItem)

#define Blt_GetBindingData(bindPtr)  ((bindPtr)->clientData)

#endif /*_BLT_BIND_H*/
