# ------------------------------------------------------------------------
# 	Makefile for library files and directories of BLT library
# ------------------------------------------------------------------------

include ../win/makedefs

version =	$(BLT_MAJOR_VERSION).$(BLT_MINOR_VERSION)
pkgdir =	$(libdir)/tcl$(v1)/blt$(version)
srcdir =	.
miscFiles =	bltCanvEps.pro bltGraph.pro \
		bltDnd.tcl bltDragdrop.tcl \
		bltGraph.tcl bltHierbox.tcl bltHiertable.tcl bltTabset.tcl \
		tclIndex htresize.cur

ddFiles =	dd-color.tcl dd-file.tcl dd-number.tcl dd-text.tcl tclIndex

instdirs =	$(prefix) $(exec_prefix) $(libdir) \
		$(scriptdir) \
		$(scriptdir)/dd_protocols \
		$(libdir)/tcl$(v1) $(pkgdir)

all: build-pkgindex

install: install-dirs install-ddfiles install-files install-pkgindex

install-dirs:
	@for i in $(instdirs) ; do \
	    if test -d "$$i" ; then : ; else mkdir "$$i" ; fi ; \
        done

install-ddfiles: install-dirs
	for i in $(ddFiles) ; do \
	    $(INSTALL_DATA) $(srcdir)/dd_protocols/$$i $(scriptdir)/dd_protocols ; \
	done 

install-files: install-dirs
	for i in $(miscFiles) ; do \
	    $(INSTALL_DATA) $(srcdir)/$$i $(scriptdir) ; \
	done 

pkgIndex.tcl: build-pkgindex

build-pkgindex:
	rm -f pkgIndex.tcl
	sed -e 's/__VERSION__/$(version)/' $(srcdir)/pkgIndex.tcl.in | \
	sed -e 's;__AUX_LIBS__;$(AUX_LIBS);' > pkgIndex.tcl

install-pkgindex: pkgIndex.tcl
	$(INSTALL_DATA) pkgIndex.tcl $(scriptdir)
	$(INSTALL_DATA) pkgIndex.tcl $(pkgdir)

clean:
	$(RM) pkgIndex.tcl
	$(RM) $(srcdir)/*.bak $(srcdir)/*\~ $(srcdir)/"#"* 

distclean: clean
	$(RM) Makefile
