#!/usr/bin/perl -w -I..

# A little shell to test functionnalities.

$h = <<'EOF'
Commands are :

"$piece $dir"  : Move a piece
     Where $piece is matches /[0-9A-Za-z]/ 
     and   $dir   is "left", "right", "down" or "up"
                  (l,r,d,u will do)

"m$piece"      : Compute the mask of $piece and show it (no space after m)
"s"            : Show current setup
"u"            : Undo
"r"            : Redo
"H"            : Show history
"h"            : Print this help

Quit with ^c.

EOF
    ;


$| = 1 ;

use Bloksi ;

$s= "AA01\n".
    "AA01\n".
    "23 8\n".
    "4467\n".
    "5567\n".
    "   9";

$g = new Bloksi $s ;
print "$g->{s}\n" ;

$dirreg = "(l(?:eft)?|r(?:ight)?|d(?:own)?|u(?:p)?)";
%fuldir = ("l"=>"left","r"=>"right","u"=>"up","d"=>"down",);

while( 1 )
{
    $_ = <> ;
    chomp;
    if(/^\s*([0-9A-Za-z])\s+($dirreg)/){

	## Try move
	$p = $1 ;
	$d = $2 ;
	$d = $fuldir{$d} if exists $fuldir{$d} ;
	print "Trying to move '$p' in dir '$d'\n";
	$g->move_clean($p,$d);
	print "$g->{s}\n" ;

    } elsif(/^\s*h/){

	print $h ;

    } elsif(/^\s*u/){

	print "Undoing\n" ;
	$g->undo_move();
	print "Hist : ",0+@{$g->{history}},", Redo : ",0+@{$g->{undone}},"\n";
	print "$g->{s}\n" ;

    } elsif(/^\s*r/){

	print "Redoing\n" ;
	$g->redo_move();
	print "Hist : ",0+@{$g->{history}},", Redo : ",0+@{$g->{undone}},"\n";
	print "$g->{s}\n" ;

    } elsif(/^\s*m([0-9A-Za-z])/){

	print "Mask for $1 is \n" ;
	$m = piece_mask($g,$1) ;
	print("Size : $m->{size}->[0] x $m->{size}->[1]\n",
	      "Mask : '$m->{mask}'\n",
	      "Iden : '$m->{iden}'\n");
    
    } elsif(/^\s*s/){

	print "Current situation is :\n-----\n$g->{s}\n-----\n";

    } elsif(/^\s*H/){

	print "Hisrory is :\n";
	foreach (@{$g->{history}}){
	    print "---------\n$_->{s}\n" ;
	}
	print "---------\n" ;
	print "Undone is :\n";
	foreach (@{$g->{undone}}){
	    print "---------\n$_->{s}\n" ;
	}
	print "---------\n" ;
	

    } elsif(0){
    
    } else {
	print "Unknown command '$_'. Try 'h'.\n" ;
    }
}


