/** 
 * @namespace   biewlib
 * @file        biewlib/sysdep/generic/_inlines.h
 * @brief       This file includes generic architecture little inline functions.
 * @version     -
 * @remark      this source file is part of Binary vIEW project (BIEW).
 *              The Binary vIEW (BIEW) is copyright (C) 1995 Nick Kurshev.
 *              All rights reserved. This software is redistributable under the
 *              licence given in the file "Licence.en" ("Licence.ru" in russian
 *              translation) distributed in the BIEW archive.
 * @note        Requires POSIX compatible development system
 *
 * @author      Nick Kurshev
 * @since       2000
 * @note        Development, fixes and improvements
**/
#ifndef ___INLINES_H
#define ___INLINES_H 1

#ifdef __clpusplus
extern "C" {
#endif

#define __NEAR__           /**< Not usable for generic platform modifier of near call and data */
#define __FAR__            /**< Not usable for generic platform modifier of far call and data */
#define __HUGE__           /**< Not usable for generic platform modifier of huge pointer */
#define __INTERRUPT__      /**< Not usable for generic platform modifier of interrupt call */
#define halloc malloc      /**< For generic platform is alias of huge malloc */
#define hrealloc realloc   /**< For generic platform is alias of huge realloc */
#define hfree free         /**< For generic platform is alias of huge free */
#define HMemCpy memcpy     /**< For generic platform is alias of huge memcpy */

#define __FASTCALL__       /**< Impossible for definition on generic platform modifier of fast call */
#define __NORETURN__       /**< Impossible for definition on generic platform modifier of function that never return contol */
#define __CONSTFUNC__      /**< Impossible for definition on generic platform modifier of constant function */

                /** Changes byte order in 32-bit number */
#define ByteSwapL(_val)\
  (((unsigned long)_val << 24) | (((unsigned long)_val & 0xFF00) << 8) |\
  (((unsigned long)_val & 0xFF0000L) >> 8) | ((unsigned long)_val >> 24))

                /** Changes byte order in 16-bit number */
#define ByteSwapS(_val)\
  (((unsigned short)_val << 8) | ((unsigned short)_val >> 8))

                /** Translates byte via table lookup 
                  * @return         byte readed from table \e t at offset \e i
                  * @param t        pointer to 256-byte memory block from which will be readed byte
                  * @param i        index of memory block where byte is to be readed
                **/
#define __Xlat__(t,i) (t[i])

#ifdef __cplusplus
}
#endif

#endif
