#!/usr/bin/env python
# -*- coding: iso-8859-1 -*-
#file test_lfuns.py

"""Test functions and classes in the LyX.lfuns module

Revision History:

2005-05-26 Gnter Milde first version with the unittest framework
"""

from unittest import TestCase, main 

from LyX.lfuns import *


class lfunsTests(TestCase):
    """Test public functions in foo.py"""
    def test_lfun_return_value(self):
        """lfuns should return a string value"""
        # open a new buffer
        self.assertEqual(buffer_new(), "")
        # get a return value
        self.assertEqual(server_get_layout(), "Standard")
        # close buffer
        self.assertEqual(buffer_close(), "")
    #
    def test_lfun_with_argument(self):
        """lfuns should take a variable number of arguments"""
        # check lfun with argument
        self.assertEqual(apropos("lyx-quit"), "Exit")


if __name__ == '__main__':    #run tests if called from command-line
    main()
