/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#include "libraries.h"
#include "utilities.h"
#include "xslfoendnote.h"
#include "usfmtools.h"
#include "constants.h"
#include "gwrappers.h"


XslFoEndnote::XslFoEndnote (const Usfm& usfm, bool show)
// Stores the properties for all the endnote related styles.
{
  // Store and initialize variables.
  myshow = show;
  
  // Go through all the styles.
  for (unsigned int i = 0; i < usfm.styles.size(); i++) {
    if (usfm.styles[i].type == stFootEndNote) {
      // Check subtype.
      FootEndNoteType footnotetype = (FootEndNoteType) usfm.styles[i].subtype;
      switch (footnotetype) {
        case fentFootnote:
        {
          // Footnotes not dealt with here.
          break;
        }
        case fentEndnote:
        {
          // Store data for the markers and the anchor.
          opening_marker = usfm_get_full_opening_marker (usfm.styles[i].marker);
          closing_marker = usfm_get_full_closing_marker (usfm.styles[i].marker);
          break;
        }
        case fentStandardContent:
        {
          break;
        }
        case fentContent:
        case fentContentWithEndmarker:
        {
          break;
        }
        case fentParagraph:
        {
          break;
        }
      }
    }
  }
}


XslFoEndnote::~XslFoEndnote ()
{
}


void XslFoEndnote::transform (XmlFoBlock * xmlfoblock, ustring& line)
// Replace all endnote related content with corresponding xslfo code.
{
  // If no opening marker in stylesheet, bail out.
  if (opening_marker.empty())
    return;
  
  // Variables.
  size_t opening_position;
  
  // Look for footnotes, but only deal with them if they have the endmarker too.
  opening_position = line.find (opening_marker);
  while (opening_position != string::npos) {
    
    // Look for the endmarker.
    size_t closing_position;
    closing_position = line.find (closing_marker, opening_position);    
    if (closing_position == string::npos) {
      gw_warning ("Endnote: missing endmarker");
      return;
    }

    // Take out this bit of the line, transform it, and insert it again.
    ustring footnote;
    footnote = line.substr (opening_position + opening_marker.length(), closing_position - opening_position - closing_marker.length());
    line.erase (opening_position, closing_position - opening_position + closing_marker.length());
    if (myshow) {
    }
    
    // Search for another footnote.
    opening_position = line.find (opening_marker, opening_position);
  }
  
}
