/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#ifndef INCLUDED_MAINWINDOW_H
#define INCLUDED_MAINWINDOW_H


#include <gtk/gtk.h>
#include "track.h"
#include "undo.h"
#include "windowsoutpost.h"
#include "ustring.h"
#include "bibletime.h"
#include "usfm.h"
#include "splashscreen.h"
#include "navigation.h"
#include "note_editor.h"
#include "editorobject.h"
#include "editor.h"
#include "generalconfig.h"
#include "session.h"


class MainWindow
{
public:
  MainWindow (SplashScreen * splashscreen);
  ~ MainWindow ();
  int run ();
  GtkWidget *mainwindow;
protected:
  /* IMPORTANT If more menu items are added see whether they should be made 
   * in(sensitive) depending on whether a project has been opened. */
  GtkWidget *vbox1;
  GtkWidget *menubar1;
  GtkWidget *menuitem_file;
  GtkWidget *menuitem_file_menu;
  GtkWidget *file_project;
  GtkWidget *image463;
  GtkWidget *file_project_menu;
  GtkWidget *new1;
  GtkWidget *image903;
  GtkWidget *open1;
  GtkWidget *close1;
  GtkWidget *delete1;
  GtkWidget *print_project;
  GtkWidget *image805;
  GtkWidget *properties1;
  GtkWidget *image4995;
  GtkWidget *import1;
  GtkWidget *image464;
  GtkWidget *export_project;
  GtkWidget *image3298;
  GtkWidget *export_project_menu;
  GtkWidget *export_usfm_files;
  GtkWidget *image12814;
  GtkWidget *to_bibleworks_version_database_compiler;
  GtkWidget *image3299;
  GtkWidget *export_to_sword_module;
  GtkWidget *image11392;
  GtkWidget *copy_project_to;
  GtkWidget *image2688;
  GtkWidget *compare_with1;
  GtkWidget *image2764;
  GtkWidget *parallel_bible;
  GtkWidget *image11566;
  GtkWidget *synchronize_projects;
  GtkWidget *image12270;
  GtkWidget *file_references;
  GtkWidget *image465;
  GtkWidget *file_references_menu;
  GtkWidget *open_references1;
  GtkWidget *image466;
  GtkWidget *references_save_as;
  GtkWidget *print_references;
  GtkWidget *image759;
  GtkWidget *close_references;
  GtkWidget *image468;
  GtkWidget *delete_references;
  GtkWidget *image469;
  GtkWidget *reference_hide;
  GtkWidget *image6483;
  GtkWidget *style;
  GtkWidget *image10735;
  GtkWidget *style_menu;
  GtkWidget *stylesheets_expand_all;
  GtkWidget *image10736;
  GtkWidget *stylesheets_collapse_all;
  GtkWidget *image10737;
  GtkWidget *style_insert;
  GtkWidget *image10738;
  GtkWidget *stylesheet_edit_mode;
  GtkWidget *style_new;
  GtkWidget *image10739;
  GtkWidget *style_properties;
  GtkWidget *style_delete;
  GtkWidget *menu_stylesheet;
  GtkWidget *image10740;
  GtkWidget *menu_stylesheet_menu;
  GtkWidget *stylesheet_switch;
  GtkWidget *image10741;
  GtkWidget *stylesheets_new;
  GtkWidget *image10742;
  GtkWidget *stylesheets_delete;
  GtkWidget *image10743;
  GtkWidget *stylesheets_rename;
  GtkWidget *image10744;
  GtkWidget *stylesheets_import;
  GtkWidget *image10745;
  GtkWidget *stylesheets_export;
  GtkWidget *image10746;
  GtkWidget *notes2;
  GtkWidget *image936;
  GtkWidget *notes2_menu;
  GtkWidget *new_note;
  GtkWidget *delete_note;
  GtkWidget *image963;
  GtkWidget *import_notes;
  GtkWidget *image1455;
  GtkWidget *export_notes;
  GtkWidget *image4068;
  GtkWidget *quit1;
  GtkWidget *menuitem_edit;
  GtkWidget *menuitem_edit_menu;
  GtkWidget *cut1;
  GtkWidget *copy1;
  GtkWidget *paste1;
  GtkWidget *separator2;
  GtkWidget *undo1;
  GtkWidget *image295;
  GtkWidget *redo1;
  GtkWidget *image296;
  GtkWidget *separator4;
  GtkWidget *find1;
  GtkWidget *find_and_replace1;
  GtkWidget *find_in_notes1;
  GtkWidget *image1430;
  GtkWidget *separator7;
  GtkWidget *get_references_from_note;
  GtkWidget *image3158;
  GtkWidget *menuitem_view;
  GtkWidget *menuitem_view_menu;
  GtkWidget *screen_font;
  GtkWidget *image8005;
  GtkWidget *printer_font;
  GtkWidget *image8006;
  GtkWidget *viewnotes;
  GtkWidget *image2627;
  GtkWidget *screen_layout;
  GtkWidget *image11944;
  GtkWidget *insert1;
  GtkWidget *insert1_menu;
  GtkWidget *standard_text_1;
  GtkWidget *image1963;
  GtkWidget *standard_text_2;
  GtkWidget *image1964;
  GtkWidget *standard_text_3;
  GtkWidget *image1965;
  GtkWidget *standard_text_4;
  GtkWidget *image1966;
  GtkWidget *separator9;
  GtkWidget *current_reference1;
  GtkWidget *image3797;
  GtkWidget *separator13;
  GtkWidget *insert_footnote;
  GtkWidget *image10927;
  GtkWidget *insert_endnote;
  GtkWidget *image10928;
  GtkWidget *insert_crossreference;
  GtkWidget *image10929;
  GtkWidget *menuitem_goto;
  GtkWidget *menuitem_goto_menu;
  GtkWidget *next_verse1;
  GtkWidget *image95;
  GtkWidget *previous_verse1;
  GtkWidget *image96;
  GtkWidget *next_chapter1;
  GtkWidget *image97;
  GtkWidget *previous_chapter1;
  GtkWidget *image98;
  GtkWidget *next_book1;
  GtkWidget *image99;
  GtkWidget *previous_book1;
  GtkWidget *image100;
  GtkWidget *next_reference1;
  GtkWidget *image608;
  GtkWidget *previous_reference1;
  GtkWidget *image609;
  GtkWidget *next_reference_in_history1;
  GtkWidget *image5687;
  GtkWidget *previous_reference_in_history1;
  GtkWidget *image5688;
  GtkWidget *reference1;
  GtkWidget *image101;
  GtkWidget *text_area1;
  GtkWidget *image4721;
  GtkWidget *goto_bible_notes_area1;
  GtkWidget *image11878;
  GtkWidget *references_area1;
  GtkWidget *image4722;
  GtkWidget *insert_style;
  GtkWidget *image11111;
  GtkWidget *notes_area1;
  GtkWidget *image4723;
  GtkWidget *separator11;
  GtkWidget *synchronize_other_programs2;
  GtkWidget *image4931;
  GtkWidget *check1;
  GtkWidget *check1_menu;
  GtkWidget *chapters_and_verses1;
  GtkWidget *image5580;
  GtkWidget *markers1;
  GtkWidget *image5578;
  GtkWidget *markers1_menu;
  GtkWidget *validate_usfms1;
  GtkWidget *image5579;
  GtkWidget *count_usfms1;
  GtkWidget *image6239;
  GtkWidget *compare_usfm1;
  GtkWidget *image6748;
  GtkWidget *characters1;
  GtkWidget *image6867;
  GtkWidget *characters1_menu;
  GtkWidget *count_characters;
  GtkWidget *image6868;
  GtkWidget *unwanted_patterns;
  GtkWidget *image7494;
  GtkWidget *check_words;
  GtkWidget *image7111;
  GtkWidget *check_words_menu;
  GtkWidget *check_capitalization;
  GtkWidget *image7112;
  GtkWidget *check_repetition;
  GtkWidget *image7238;
  GtkWidget *unwanted_words;
  GtkWidget *image7631;
  GtkWidget *word_count_inventory;
  GtkWidget *image13715;
  GtkWidget *check_punctuation;
  GtkWidget *image7366;
  GtkWidget *check_punctuation_menu;
  GtkWidget *check_matching_pairs;
  GtkWidget *image7367;
  GtkWidget *menutools;
  GtkWidget *menutools_menu;
  GtkWidget *line_cutter_for_hebrew_text1;
  GtkWidget *image13532;
  GtkWidget *menuitem_preferences;
  GtkWidget *menuitem_preferences_menu;
  GtkWidget *notes_preferences;
  GtkWidget *image2116;
  GtkWidget *printingprefs;
  GtkWidget *image3493;
  GtkWidget *formatting_objects_processor;
  GtkWidget *image3718;
  GtkWidget *reference_exchange1;
  GtkWidget *image5972;
  GtkWidget *ignored_references1;
  GtkWidget *image6467;
  GtkWidget *prefs_books;
  GtkWidget *image12167;
  GtkWidget *preferences_synchronization;
  GtkWidget *image12530;
  GtkWidget *preferences_debug;
  GtkWidget *menuitem_help;
  GtkWidget *menuitem_help_menu;
  GtkWidget *help1;
  GtkWidget *system_log1;
  GtkWidget *image4388;
  GtkWidget *about1;
  GtkWidget *toolbar1;
  GtkWidget *button_back;
  GtkWidget *image1;
  GtkWidget *button_forward;
  GtkWidget *image2;
  GtkObject *spinbutton_book_adj;
  GtkWidget *spinbutton_book;
  GtkWidget *comboboxentry_book;
  GtkObject *spinbutton_chapter_adj;
  GtkWidget *spinbutton_chapter;
  GtkWidget *comboboxentry_chapter;
  GtkObject *spinbutton_verse_adj;
  GtkWidget *spinbutton_verse;
  GtkWidget *comboboxentry_verse;
  GtkWidget *hbox1;
  GtkWidget *hpaned1;
  GtkWidget *vbox_left;
  GtkWidget *vpaned1;
  GtkWidget *vpaned_editor;
  GtkWidget *scrolledwindow1;
  // In Editor object. GtkWidget *textview_edit;
  GtkWidget *scrolledwindow10;
  // In Editor object. GtkWidget *textview_footnotes;
  GtkWidget *notebook1;
  GtkWidget *scrolledwindow3;
  GtkWidget *textview_notes;
  GtkWidget *label1;
  GtkWidget *hbox3;
  GtkWidget *scrolledwindow4;
  GtkWidget *textview_note;
  GtkWidget *vbox4;
  GtkWidget *button_note_ok;
  GtkWidget *button_note_cancel;
  GtkWidget *label2;
  GtkWidget *vbox_right;
  GtkWidget *notebook_tools;
  GtkWidget *vpaned_references;
  GtkWidget *scrolledwindow_references;
  GtkWidget *treeview_references;
  GtkWidget *scrolledwindow_quick_refs;
  GtkWidget *textview_quick_refs;
  GtkWidget *label13;
  GtkWidget *scrolledwindow7;
  GtkWidget *treeview_styles;
  GtkWidget *label14;
  GtkWidget *notebook3;
  GtkWidget *vbox3;
  GtkWidget *label_note_category;
  GtkWidget *combobox_note_category;
  GtkWidget *label_note_references;
  GtkWidget *scrolledwindow8;
  GtkWidget *textview_note_references;
  GtkWidget *label_note_project;
  GtkWidget *combobox_note_project;
  GtkWidget *label_note_created_on;
  GtkWidget *label_note_created_by;
  GtkWidget *label_note_edited_on;
  GtkWidget *label_note_logbook;
  GtkWidget *scrolledwindow9;
  GtkWidget *textview_note_logbook;
  GtkWidget *label18;
  GtkWidget *label17;
  GtkWidget *label20;
  GtkWidget *label_notetools;
  GtkWidget *hbox5;
  GtkWidget *hbox7;
  GtkWidget *statuslabel_stylesheet;
  GtkWidget *statusbutton_attention;
  GtkWidget *alignment1;
  GtkWidget *hbox8;
  GtkWidget *image12350;
  GtkWidget *label21;
  GtkWidget *statusbar1;
  GtkAccelGroup *accel_group;
  // Gtk variables manually added.
  GtkTextBuffer *textbuffer_notes;
  GtkListStore *liststore_references;
  GtkTreeViewColumn *treecolumn_references;
  GtkTreeSelection *treeselect_references;
  GtkTreeStore *treestore_styles;
  GtkTreeViewColumn *treecolumn_styles;
  GtkTreeSelection *treeselect_styles;

  // Editor
  Editor editor;

  /* Initialization */
  void close_open_project (ustring project);
  void initialize_project (bool init_book_selection);
  void enable_or_disable_widgets (bool enable);

  /* Menu callbacks */
  static void on_open1_activate (GtkMenuItem * menuitem, gpointer user_data);
  void open ();
  static void on_close1_activate (GtkMenuItem * menuitem, gpointer user_data);
  void close ();
  static void on_new1_activate (GtkMenuItem * menuitem, gpointer user_data);
  void newproject ();
  static void on_properties1_activate (GtkMenuItem * menuitem, gpointer user_data);
  void editproject ();
  static void on_delete1_activate (GtkMenuItem * menuitem, gpointer user_data);
  void deleteproject ();
  static void on_quit1_activate (GtkMenuItem * menuitem, gpointer user_data);
  static void on_system_log1_activate (GtkMenuItem * menuitem, gpointer user_data);
  void viewlog ();
  static void on_help1_activate (GtkMenuItem * menuitem, gpointer user_data);
  static void on_about1_activate (GtkMenuItem * menuitem, gpointer user_data);
  void showabout ();
  static void on_undo1_activate (GtkMenuItem * menuitem, gpointer user_data);
  void menu_undo ();
  static void on_redo1_activate (GtkMenuItem * menuitem, gpointer user_data);
  void menu_redo ();
  static void on_edit1_activate (GtkMenuItem * menuitem, gpointer user_data);
  void menu_edit ();
  static void on_find_and_replace1_activate (GtkMenuItem * menuitem, gpointer user_data);
  void menu_replace ();
  static void on_findspecial1_activate (GtkMenuItem * menuitem, gpointer user_data);
  void menu_findspecial ();
  static void on_screen_font_activate (GtkMenuItem * menuitem, gpointer user_data);
  void on_screen_font ();
  static void on_printer_font_activate (GtkMenuItem * menuitem, gpointer user_data);
  void on_printer_font ();
  static void on_import1_activate (GtkMenuItem * menuitem, gpointer user_data);
  void menu_import ();
  static gboolean on_mainwindow_delete_event (GtkWidget *widget, GdkEvent *event, gpointer user_data);
  static gboolean on_mainwindow_focus_in_event (GtkWidget *widget, GdkEventFocus *event, gpointer user_data);
  void on_mainwindow_focus_in (GdkEventFocus *event);
  static void on_print_project_activate (GtkMenuItem *menuitem, gpointer user_data);
  void on_print_project ();
  static void on_insert1_activate (GtkMenuItem *menuitem, gpointer user_data);
  void on_menu_insert ();
  static void on_notes_preferences_activate (GtkMenuItem *menuitem, gpointer user_data);
  void on_notes_preferences ();
  static void on_copy_project_to_activate (GtkMenuItem *menuitem, gpointer user_data);
  void on_copy_project_to ();
  static void on_compare_with1_activate (GtkMenuItem *menuitem, gpointer user_data);
  void on_compare_with ();
  static void on_printingprefs_activate (GtkMenuItem *menuitem, gpointer user_data);
  void on_printing_preferences ();
  static void on_formatting_objects_processor_activate (GtkMenuItem *menuitem, gpointer user_data);
  void on_formatter ();
  static void on_parallel_bible_activate (GtkMenuItem *menuitem, gpointer user_data);
  void on_parallel_bible ();
  static void on_screen_layout_activate (GtkMenuItem *menuitem, gpointer user_data);
  void on_screen_layout ();
  static void on_prefs_books_activate (GtkMenuItem *menuitem, gpointer user_data);
  void on_prefs_books ();
  static void on_preferences_debug_activate (GtkMenuItem *menuitem,  gpointer user_data);
  void on_preferences_debug ();

  /* Navigation  */
  static void on_combo_entry_book_changed (GtkEditable * editable, gpointer user_data);
  void on_combo_book_changed ();
  static void on_combo_entry_chapter_changed (GtkEditable * editable, gpointer user_data);
  void on_combo_chapter_changed ();
  static void on_combo_entry_verse_changed (GtkEditable * editable, gpointer user_data);
  void on_combo_verse_changed ();
  static void on_next_verse_activate (GtkMenuItem * menuitem, gpointer user_data);
  void goto_next_verse ();
  static void on_previous_verse_activate (GtkMenuItem * menuitem, gpointer user_data);
  void goto_previous_verse ();
  static void on_next_chapter_activate (GtkMenuItem * menuitem, gpointer user_data);
  void goto_next_chapter ();
  static void on_previous_chapter_activate (GtkMenuItem * menuitem, gpointer user_data);
  void goto_previous_chapter ();
  static void on_next_book_activate (GtkMenuItem * menuitem, gpointer user_data);
  void goto_next_book ();
  static void on_previous_book_activate (GtkMenuItem * menuitem, gpointer user_data);
  void goto_previous_book ();
  static void on_reference_activate (GtkMenuItem * menuitem, gpointer user_data);
  void goto_reference_interactive ();
  void go_to_new_reference ();
  bool go_to_new_reference_active; // Probably can go out.
  guint go_to_new_reference_event_id;
  static bool go_to_new_reference_delayer (gpointer user_data);
  void go_to_new_reference_executer ();
  ustring editor_current_book, editor_current_chapter, editor_current_verse;
  bool settingcombos;
  static void on_textview_edit_move_cursor (GtkTextView * textview, GtkMovementStep step, gint count, gboolean extend_selection, gpointer user_data);
  void on_cursor_moved_delayer ();
  static bool on_cursor_moved_delayer_handler (gpointer user_data);
  guint cursor_moved_delayer_event_id;
  void on_cursor_moved ();
  bool focus_programmatically_being_grabbed;
  static void on_textview_edit_grab_focus (GtkWidget * widget, gpointer user_data);
  void on_grab_focus ();
  guint grab_focus_event_id;
  ustring cursor_get_verse_number ();
  static bool mainwindow_on_grab_focus_delayed_handler (gpointer data);
  bool on_grab_focus_delayed_handler ();
  static void on_text_area1_activate (GtkMenuItem *menuitem, gpointer user_data);
  void on_text_area_activate ();
  static void on_goto_bible_notes_area1_activate (GtkMenuItem *menuitem, gpointer user_data);
  void on_bible_notes_area_activate ();
  static void on_tools_area1_activate (GtkMenuItem *menuitem, gpointer user_data);
  void on_tools_area_activate ();
  static void on_notes_area1_activate (GtkMenuItem *menuitem, gpointer user_data);
  void on_notes_area_activate ();
  static void on_synchronize_other_programs2_activate (GtkMenuItem *menuitem, gpointer user_data);
  void on_synchronize_other_programs ();
  static void on_spinbutton_book_value_changed (GtkSpinButton *spinbutton, gpointer user_data);
  static void on_spinbutton_chapter_value_changed (GtkSpinButton *spinbutton, gpointer user_data);
  static void on_spinbutton_verse_value_changed (GtkSpinButton *spinbutton, gpointer user_data);
  void on_spinbutton_book ();
  void on_spinbutton_chapter ();
  void on_spinbutton_verse ();
  int spinbutton_book_previous_value;
  int spinbutton_chapter_previous_value;
  int spinbutton_verse_previous_value;
  static bool on_program_startup_timeout (gpointer data);
  void on_program_startup ();

  /* Tracker */
  static void on_button_forward_clicked (GtkButton * button, gpointer user_data);
  static void on_next_reference_in_history1_activate (GtkMenuItem *menuitem, gpointer user_data);
  void goto_next_reference ();
  static void on_button_back_clicked (GtkButton * button, gpointer user_data);
  static void on_previous_reference_in_history1_activate (GtkMenuItem *menuitem, gpointer user_data);
  void goto_previous_reference ();
  void set_sensitivity_of_navigator_buttons ();
  static bool mainwindow_on_tracker_timeout (gpointer data);
  bool on_tracker_timeout ();
  void set_next_or_previous_reference (bool next);
  Track track;

  /* Variables for general use */
  GeneralConfiguration * genconfig;
  Session session;

  /* Loading, editing, saving */
  void editor_load_chapter ();
  void editor_position_cursor_at_verse (const ustring& cursorposition);
  ustring editor_position_cursor_at_verse_cursorposition;
  static bool editor_position_cursor_at_verse_postponer_handler (gpointer user_data);
  gint editor_position_cursor_at_verse_event_id;
  void editor_position_cursor_at_verse_executer ();
  void editor_save ();
  static bool mainwindow_on_save_timeout (gpointer data);
  bool on_save_timeout ();
  void editor_set_font ();

  /* Clipboard */
  static void on_cut1_activate (GtkMenuItem * menuitem, gpointer user_data);
  void on_cut ();
  static void on_copy1_activate (GtkMenuItem * menuitem, gpointer user_data);
  void on_copy ();
  static void on_paste1_activate (GtkMenuItem * menuitem, gpointer user_data);
  void on_paste ();

  /* Backups */
  //  Backup backup;

  /* Tools Area */
  static void on_notebook_tools_switch_page (GtkNotebook *notebook, GtkNotebookPage *page, guint page_num, gpointer user_data);
  void notebook_tools_switch_page (guint page_num);
  static void on_file_references_activate (GtkMenuItem *menuitem, gpointer user_data);
  void on_file_references ();

  /* List store and reference handling */
  static gboolean on_treeview_references_key_press_event (GtkWidget * widget, GdkEventKey * event, gpointer user_data);
  static gboolean on_treeview_references_button_press_event (GtkWidget * widget, GdkEventButton * event, gpointer user_data);
  void on_list_goto ();
  static void mainwindow_selection_foreach_function (GtkTreeModel * model, GtkTreePath * path, GtkTreeIter * iter, gpointer data);
  static void on_open_references1_activate (GtkMenuItem * menuitem, gpointer user_data);
  void on_open_references ();
  ustring selected_reference;
  static void on_references_save_as_activate (GtkMenuItem * menuitem, gpointer user_data);
  void on_save_references ();
  static void on_print_references_activate (GtkMenuItem *menuitem, gpointer user_data);
  void on_print_references ();
  static void on_close_references_activate (GtkMenuItem * menuitem, gpointer user_data);
  void on_clear_references ();
  static void on_delete_references_activate (GtkMenuItem * menuitem, gpointer user_data);
  void on_delete_references ();
  static void on_references_collect_iters (GtkTreeModel * model, GtkTreePath * path, GtkTreeIter * iter, gpointer data);
  static void on_next_reference1_activate (GtkMenuItem * menuitem, gpointer user_data);
  void on_next_reference ();
  static void on_previous_reference1_activate (GtkMenuItem * menuitem, gpointer user_data);
  void on_previous_reference ();
  GtkTextTag * editor_reference_tag;
  static void on_ignored_references1_activate (GtkMenuItem *menuitem, gpointer user_data);
  void on_ignored_references ();
  static gboolean on_treeview_references_popup_menu (GtkWidget *widget, gpointer user_data);
  void treeview_references_popup_menu (GtkWidget *widget);
  static void on_reference_hide_activate (GtkMenuItem *menuitem, gpointer user_data);
  void on_reference_hide ();
  void show_references_popup_menu (GtkWidget *my_widget, GdkEventButton *event);
  static gboolean on_treeview_references_move_cursor (GtkTreeView *treeview, GtkMovementStep step, gint count, gpointer user_data);
  static void on_treeview_references_cursor_changed (GtkTreeView *treeview, gpointer user_data);
  void treeview_references_display_quick_reference ();

  /* Undo and Redo */
  Undo undo;
  static void on_textbuffer_edit_insert_text (GtkTextBuffer * textbuffer, GtkTextIter * arg1, gchar * arg2, gint arg3, gpointer user_data);
  static void on_textbuffer_edit_delete_text (GtkTextBuffer * textbuffer, GtkTextIter * arg1, GtkTextIter * arg2, gpointer user_data);
  void on_textbuffer_edit_insert_delete ();  
  static bool on_undo_timeout (gpointer data);
  bool undo_timeout ();

  // Bibledit Windows Outpost
  // BibleTime
  static bool mainwindow_on_external_programs_timeout (gpointer data);
  bool on_external_programs_timeout ();
  WindowsOutpost windowsoutpost;
  static void on_reference_exchange1_activate (GtkMenuItem *menuitem, gpointer user_data);
  void on_reference_exchange ();
  BibleTime bibletime;
  ustring bibledit_bt_previous_reference;
  ustring bibletime_previous_reference;
  static gboolean on_textview_edit_button_press_event (GtkWidget *widget, GdkEventButton *event, gpointer user_data);
  static gboolean on_textview_footnotes_button_press_event (GtkWidget *widget, GdkEventButton *event, gpointer user_data);
  void on_texteditor_click (GtkWidget * widget, GdkEventButton *event);
  void send_word_to_toolbox (const ustring& word);

  /* Title bar and status bar, GUI */
  void set_titlebar (const ustring& project);
  static bool on_gui_timeout (gpointer data);
  void on_gui ();

  /* Notes editor */
  static gboolean notes_motion_notify_event (GtkWidget *text_view, GdkEventMotion *event, gpointer user_data);
  gboolean on_notes_pointer_moved (GtkWidget *text_view, GdkEventMotion *event);
  void set_cursor_if_appropriate (GtkTextView *text_view, gint x, gint y);
  gboolean hovering_over_link;
  GdkCursor *hand_cursor;
  GdkCursor *regular_cursor;
  static gboolean visibility_notify_event (GtkWidget *text_view, GdkEventVisibility *event, gpointer user_data);
  gboolean on_visibility_notified (GtkWidget *text_view, GdkEventVisibility *event);
  static gboolean notes_key_press_event (GtkWidget *widget, GdkEventKey *event, gpointer user_data);
  gboolean on_notes_key_press_event (GtkWidget *widget, GdkEventKey *event);
  static void notes_event_after (GtkWidget *widget, GdkEvent *event, gpointer user_data);
  void on_notes_event_after (GtkWidget *text_view, GdkEvent *ev);
  void notes_edit_if_link (GtkWidget *text_view, GtkTextIter *iter);
  static void on_new_note_activate (GtkMenuItem *menuitem, gpointer user_data);
  void on_new_note ();
  void notes_delete_if_link (GtkWidget *text_view, GtkTextIter *start, GtkTextIter *end);
  static void on_delete_note_activate (GtkMenuItem *menuitem, gpointer user_data);
  void on_delete_note ();
  static void on_viewnotes_activate (GtkMenuItem *menuitem, gpointer user_data);
  void on_view_notes ();
  void notes_redisplay ();
  static void on_find_in_notes1_activate (GtkMenuItem *menuitem, gpointer user_data);
  void find_in_notes ();
  static void on_import_notes_activate (GtkMenuItem *menuitem, gpointer user_data);
  void on_import_notes ();
  static void on_export_notes_activate (GtkMenuItem *menuitem, gpointer user_data);
  void on_export_notes ();
  static void on_button_cancel_clicked (GtkButton *button, gpointer user_data);
  void on_notes_button_cancel ();
  static void on_button_ok_clicked (GtkButton *button, gpointer user_data);
  void on_notes_button_ok ();
  void on_notes_button_ok_cancel ();
  void notes_fill_edit_screen (int id, bool newnote);
  NoteEditor * note_editor;
  void note_insert_date_and_text (const ustring& text);
  static void on_standard_text_1_activate (GtkMenuItem *menuitem, gpointer user_data);
  static void on_standard_text_2_activate (GtkMenuItem *menuitem, gpointer user_data);
  static void on_standard_text_3_activate (GtkMenuItem *menuitem, gpointer user_data);
  static void on_standard_text_4_activate (GtkMenuItem *menuitem, gpointer user_data);
  void on_insert_standard_text (GtkMenuItem *menuitem);
  static void on_current_reference1_activate (GtkMenuItem *menuitem, gpointer user_data);
  static void on_menuitem_view_activate (GtkMenuItem *menuitem, gpointer user_data);
  void on_menuitem_view ();
  void stop_displaying_more_notes ();
  static bool on_display_notes_timeout (gpointer data);
  bool on_display_notes ();
  unsigned int on_display_notes_timer;
  unsigned int notes_ids_to_display_pointer;
  vector<unsigned int> notes_ids_to_display;
  static bool on_note_display_one (gpointer data);
  bool note_display_one ();
  static void on_get_references_from_note_activate (GtkMenuItem *menuitem, gpointer user_data);
  void on_get_references_from_note ();
  void notes_get_references_from_link (GtkWidget *text_view, GtkTextIter *iter);
  
  /* Export */
  static void on_export_usfm_files_activate (GtkMenuItem *menuitem, gpointer user_data);
  void on_export_usfm_files ();
  static void on_to_bibleworks_version_compiler_activate (GtkMenuItem *menuitem, gpointer user_data);
  void on_to_bibleworks_version_compiler ();
  static void on_export_to_sword_module_activate (GtkMenuItem *menuitem, gpointer user_data);
  void on_export_to_sword_module ();

  /* Checks */
  static void on_check1_activate (GtkMenuItem *menuitem, gpointer user_data);
  void on_menu_check ();
  static void on_markers1_activate (GtkMenuItem *menuitem, gpointer user_data);
  void on_menu_check_markers ();
  static void on_validate_usfms1_activate (GtkMenuItem *menuitem, gpointer user_data);
  void on_menu_check_markers_validate ();
  static void on_count_usfms1_activate (GtkMenuItem *menuitem, gpointer user_data);
  void on_menu_check_markers_count ();  
  static void on_compare_usfm1_activate (GtkMenuItem *menuitem, gpointer user_data);
  void on_menu_check_markers_compare ();  
  static void on_chapters_and_verses1_activate (GtkMenuItem *menuitem, gpointer user_data);
  void on_menu_check_chapters_and_verses ();
  static void on_count_characters_activate (GtkMenuItem *menuitem, gpointer user_data);
  void on_count_characters ();
  static void on_unwanted_patterns_activate (GtkMenuItem *menuitem, gpointer user_data);
  void on_unwanted_patterns ();
  static void on_check_capitalization_activate (GtkMenuItem *menuitem, gpointer user_data);
  void on_check_capitalization ();
  static void on_check_repetition_activate (GtkMenuItem *menuitem, gpointer user_data);
  void on_check_repetition ();
  static void on_check_matching_pairs_activate (GtkMenuItem *menuitem, gpointer user_data);
  void on_check_matching_pairs ();
  static void on_unwanted_words_activate (GtkMenuItem *menuitem, gpointer user_data);
  void on_unwanted_words ();
  static void on_word_count_inventory_activate (GtkMenuItem *menuitem, gpointer user_data);
  void on_word_count_inventory ();
  static bool on_check_httpd_timeout (gpointer data);
  void on_check_httpd ();

  /* Styles */
  static void on_insert_style_activate (GtkMenuItem *menuitem, gpointer user_data);
  void on_menu_insert_style ();
  static void on_file_styles (GtkMenuItem *menuitem, gpointer user_data);
  void on_menu_file_styles ();
  static void on_stylesheet_switch_activate (GtkMenuItem *menuitem, gpointer user_data);
  void on_stylesheet_switch ();
  void stylesheet_open_named (const ustring& stylesheet);
  static void on_stylesheet_edit_mode_activate (GtkMenuItem *menuitem, gpointer user_data);
  void on_stylesheet_edit_mode ();
  static void on_stylesheets_new_activate (GtkMenuItem *menuitem, gpointer user_data);
  void on_stylesheets_new ();
  static void on_stylesheets_delete_activate (GtkMenuItem *menuitem, gpointer user_data);
  void on_stylesheets_delete ();
  static void on_stylesheets_rename_activate (GtkMenuItem *menuitem, gpointer user_data);
  void on_stylesheets_rename ();
  static void on_stylesheets_import_activate (GtkMenuItem *menuitem, gpointer user_data);
  void on_stylesheets_import ();
  static void on_stylesheets_export_activate (GtkMenuItem *menuitem, gpointer user_data);
  void on_stylesheets_export ();
  static void on_style_new_activate (GtkMenuItem *menuitem, gpointer user_data);
  void on_style_new ();
  static void on_style_properties_activate (GtkMenuItem *menuitem, gpointer user_data);
  void on_style_delete ();
  static void on_style_delete_activate (GtkMenuItem *menuitem, gpointer user_data);
  void on_style_properties ();
  static gboolean on_treeview_styles_key_press_event (GtkWidget * widget, GdkEventKey * event, gpointer user_data);
  static gboolean on_treeview_styles_button_press_event (GtkWidget * widget, GdkEventButton * event, gpointer user_data);
  bool on_treeview_styles_button_press (GtkWidget * widget, GdkEventButton * event);
  static gboolean on_treeview_styles_popup_menu (GtkWidget *widget, gpointer user_data);
  void treeview_styles_popup_menu (GtkWidget *widget);
  void show_styles_popup_menu (GtkWidget *my_widget, GdkEventButton *event);
  static void on_treeview_styles_row_collapsed (GtkTreeView *treeview, GtkTreeIter *iter, GtkTreePath *path, gpointer user_data);
  static void on_treeview_styles_row_expanded (GtkTreeView *treeview, GtkTreeIter *iter, GtkTreePath *path, gpointer user_data);
  void on_treeview_styles_collapsed_expanded (GtkTreeIter *iter, GtkTreePath *path, bool expand);
  static void on_stylesheets_expand_all_activate (GtkMenuItem *menuitem, gpointer user_data);
  void on_stylesheets_expand_all ();
  static void on_stylesheets_collapse_all_activate (GtkMenuItem *menuitem, gpointer user_data);
  void on_stylesheets_collapse_all ();
  static void on_style_insert_activate (GtkMenuItem *menuitem, gpointer user_data);
  void on_style_insert ();
  bool on_style_expand ();
  bool on_style_collapse ();
  
  /* Footnotes, endnotes, crossreferences */
  static void on_insert_footnote_activate (GtkMenuItem *menuitem, gpointer user_data);
  void on_insert_footnote ();
  static void on_insert_endnote_activate (GtkMenuItem *menuitem, gpointer user_data);
  void on_insert_endnote ();
  static void on_insert_crossreference_activate (GtkMenuItem *menuitem, gpointer user_data);
  void on_insert_crossreferencenote ();

  /* Formatted view */
  static gboolean on_text_motion_notify_event (GtkWidget *textview, GdkEventMotion *event, gpointer user_data);
  gboolean text_motion_notify_event (GtkWidget *textview, GdkEventMotion *event);
  static void on_text_event_after (GtkWidget *widget, GdkEvent *event, gpointer user_data);
  void text_event_after (GtkWidget *textview, GdkEvent *ev);
  void text_edit_if_link (GtkWidget *textview, GtkTextIter *iter);
  static gboolean text_key_press_event (GtkWidget *widget, GdkEventKey *event, gpointer user_data);
  gboolean on_text_key_press_event (GtkWidget *widget, GdkEventKey *event);
  static void on_textview_footnotes_move_cursor (GtkTextView * textview, GtkMovementStep step, gint count, gboolean extend_selection, gpointer user_data);
  void on_textview_footnotes_cursor_moved ();
  static void on_textview_footnotes_grab_focus (GtkWidget * widget, gpointer user_data);
  void on_textview_footnotes_focus_grabbed ();

  /* Synchronization */
  static void on_synchronize_projects_activate (GtkMenuItem *menuitem, gpointer user_data);
  void on_synchronize_projects ();
  static void on_statusbutton_attention_clicked  (GtkButton *button, gpointer user_data);
  void on_statusbutton_attention ();
  void attention_show_hide (bool show);
  bool attend_to_sync_project;
  bool attend_to_sync_all;
  static void on_preferences_synchronization_activate (GtkMenuItem *menuitem, gpointer user_data);
  void on_preferences_synchronization ();
  guint sync_source_id;
  static bool synchronize_project_timeout (gpointer data);
  void on_synchronize_project_timeout ();
  void synchronize_project ();
  
  /* Tools */
  static void on_menutools_activate (GtkMenuItem *menuitem, gpointer user_data);
  static void on_line_cutter_for_hebrew_text1_activate (GtkMenuItem *menuitem, gpointer user_data);
  void on_line_cutter_for_hebrew_text ();

};


#endif
