/* beef - tape_dump.c
    Copyright (C) 2005-2006  KiyuKo
    This file is part of beef 0.0.5

     This program is free software; you can redistribute it and/or
     modify it under the terms of the GNU General Public License as
     published by the Free Software Foundation; either version 2 of
     the License, or (at your option) any later version.

     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with this program; if not, write to the Free Software
     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

     For any comment about this program, or eventually for bug report,
     feel free to mail <eof AT kiyuko DOT org>
     The program page is on http://www.kiyuko.org/beef */

#include "beef.h"

/* Prints the content of the tape on stderr.
 * Please note that any value is considered a char, so you can have strange
 * results when dumping the tape */
void tape_dump ()
{
  struct tape_cell *temp;
  /* temp points to the current cell */
  temp = tape;
  /* While there are cells on the left... */
  while (temp->previous != NULL)
    /* ... go left one cell */
    temp = temp->previous;
  fputs ("\n\t", stdout);
  do {
    /* Print the content of this cell and go to the next... */
    if (isprint (temp->content))
      fprintf (stdout, "[%c]", temp->content);
    else
      fprintf (stdout, "[\\%d]", temp->content);
    temp = temp->next;
  /* ... while there are other cells */
  } while (temp != NULL);
  fputs ("\n", stdout);
}

