# Copyright (C) 2001, Hewlett-Packard Corporation
# Licensed under the GNU General Public License
#  $Id: Patches.pm,v 1.16 2001/12/18 00:33:13 hpbuck Exp $
package Bastille::Patches;

use Bastille::API;

@ENV="";
$ENV{PATH}="";
$ENV{CDPATH}=".";
$ENV{BASH_ENV}="";

delete $ENV{BASH_ENV};


#######################################################################
##                          Patches Module                            #
#######################################################################
#
# The purpose of this module is to Install Security Patch Check and/or
# configure it.

&InstallSPC;
&SpcRun;
&CronSPC;

sub InstallSPC {
  my $spc = &getGlobal('FILE','spc');
  if ( $GLOBAL_DISTRO =~ "^HP-UX" and !( -e $spc ) ) {
    my $spc_install_text = 
        "Patching known security vulnerabilities is one of the most\n" .
        "important steps you can take to secure a system. Security\n" .
        "Patch Check is a tool which analyzes the software installed\n" .
        "on your system.  It will tell you if any relevant security\n" .
        "patches have been announced by Hewlett Packard that are not\n" .
        "currently installed on your system.  Bastille has detected\n" .
        "that you have not installed this tool.\n\n" .

        "Please install Security Patch Check.  You can get it at:\n" . 
	"   http://www.software.hp.com/cgi-bin/swdepot_parser.cgi/cgi/displayProductInfo.pl?productNumber=B6834AA";
	&B_TODO($spc_install_text);
  }
}

# To successfully run SPC in the cron and at Bastille run-time, the root user must accept the disclaimer
# We will add the disclaimer on Bastille backend

sub SpcRun {
    if ((&getGlobalConfig("Patches","spc_run") eq "Y")) {
	my $proxy = &getGlobalConfig("Patches","spc_proxy");
	if ($proxy ne "") {           # set proxy variable to the user's answer if one exists
	    $proxy = "export ftp_proxy=" . $proxy . "; ";
	}
	&B_TODO("Please read the patch information below and " .
                "install patches as appropriate:\n");
        my $spc = &getGlobal('FILE','spc');
	my $envexport = "export PASSIVE_FTP=1; export PATH=/usr/bin:/sbin;";
	my $catalogdir = &getGlobal('BDIR',"home");
	&B_TODO(`$envexport $proxy $spc -r -q -d -c $catalogdir/security_catalog 2>&1` . "\n\n");
    }
}

sub CronSPC {
    if ((&getGlobalConfig("Patches","spc_cron_run") eq "Y") || 
	(&getGlobalConfig("Patches","spc_cron_norun") eq "Y")) {
	my $proxy = &getGlobalConfig("Patches","spc_proxy");
	my $umask = &getGlobal('BIN',"umask") . " 077;";
	my $envexport = "$umask export PASSIVE_FTP=1; export PATH=/usr/bin:/sbin;";
	my $catalogdir = &getGlobal('BDIR',"home");
	if ($proxy ne "") {      # set proxy variable to the user's answer if one exists
	    $proxy = "export ftp_proxy=" . $proxy . "; ";
	}
      
	srand; # seed the random number generator (should this use system time?)
               # this is to prevent everyone from trying to access the ftp server
	       # at the same time.
	my $minute = int(rand(60));

	# set up the cron file for root
	unless ( -e &getGlobal('FILE', "root_cron") ) {
	    &B_create_file(&getGlobal('FILE', "root_cron"));
	}
        # running crontab in the "do" portion is just to check exit status to see
        # whether or not to undo it, and this call to B_System is just to get the
        # order right for undo
	&B_System(&getGlobal('BIN','crontab') . " " .&getGlobal('FILE','root_cron'), 
		  &getGlobal('BIN','crontab') . " " .&getGlobal('FILE','root_cron'));
	
	# adding or modifying spc line in the cron file.
        my $line = "$minute " . &getGlobalConfig("Patches", 'spc_cron_time') . 
                   " * * * ($envexport $proxy " . &getGlobal('FILE','spc') . 
                   " -r -q -d -c $catalogdir/security_catalog )\n";

	if (!&B_replace_line(&getGlobal('FILE', "root_cron"),
                       &getGlobal('FILE','spc'), $line)) {
	   &B_append_line(&getGlobal('FILE', "root_cron"),
                          &getGlobal('FILE','spc'), $line);
        }

	# crontabing file for cron so that it rereads its configs.
	&B_System(&getGlobal('BIN','crontab') . " " .&getGlobal('FILE','root_cron'), 
		  &getGlobal('BIN','crontab') . " " .&getGlobal('FILE','root_cron'));
	
    }
}

1;











