# Copyright (C) 1999 - 2001 Jay Beale
# assisted by Michael Rash
# Licensed under the GNU General Public License

#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#
# NOTE   : This module is a first attempt at having a Bastille-friendly
#	   installer for psad.
#

package Bastille::PSAD;
use lib "/usr/lib";

use Bastille::API;
@ENV="";
undef(%ENV);
$ENV{PATH}="";
$ENV{CDPATH}=".";
$ENV{BASH_ENV}="";

# @psadOptions contains information about the variables this script sets the value of
# in the final psad script. Each item in @psadOptions is a hash describing a certain
# environment variable. 
#
# Each such hash should have the following name-value pairs:
#	varname		the actual variable name for the psad perl script
#	default		the default/suggested value for that variable (in case nothing in the config)
#	configname	the name for the user's choice for this question, as read
#			from the "config" script


@psadOptions = (

	{
	'varname' => "CHECK_INTERVAL",
	'default' => "15",
	'configname' => 'psad_check_interval',
	},

	{
	'varname' => "PORT_RANGE_SCAN_THRESHOLD",
	'default' => "1",
	'configname' => 'psad_port_range_scan_threshold',
	},

	{
	'varname' => "ENABLE_PERSISTENCE",
	'default' => "N",
	'configname' => 'psad_enable_persistence',
	},

	{
	'varname' => "SCAN_TIMEOUT",
	'default' => "3600",
	'configname' => 'psad_scan_timeout',
	},

	{
	'varname' => "SHOW_ALL_SIGNATURES",
	'default' => "N",
	'configname' => 'psad_show_all_signatures',
	},

	{
	'varname' => "DANGER_LEVELS",
	'default' => "5 50 1000 5000 10000",
	'configname' => 'psad_danger_levels',
	},

	{
	'varname' => "ENABLE_EMAIL_ALERTS",
	'default' => "Y",
	'configname' => 'psad_enable_email_alerts',
	},

	{
	'varname' => "EMAIL_ADDRESSES",
	'default' => 'root@localhost',
	'configname' => 'psad_email_alert_addresses',
	},

	{
	'varname' => "EMAIL_ALERT_DANGER_LEVEL",
	'default' => "1",
	'configname' => 'psad_email_alert_danger_level',
	},

	{
	'varname' => "ALERT_ALL",
	'default' => "Y",
	'configname' => 'psad_alert_all',
	},

	{
	'varname' => "ENABLE_AUTO_IDS",
	'default' => "N",
	'configname' => 'psad_enable_auto_ids',
	},

	{
	'varname' => "AUTO_IDS_DANGER_LEVEL",
	'default' => "5",
	'configname' => 'psad_auto_ids_danger_level',
	},

        {
	'varname' => "PSAD_ENABLE_AT_BOOT",
        'default' => "N",
        'configname' => 'psad_enable_at_boot',
        }
);

&InstallScript_simpler;

#============== sub routines =============
sub InstallScript_simpler() {

    my $configPrefix="PSAD";

    my $psad_daemon = "/usr/sbin/psad";
    my $virgin_psad_daemon = "/psad";

    my $psadwatchd_daemon = "/usr/sbin/psadwatchd";
    my $virgin_psadwatchd_daemon = "/psadwatchd";

    my $kmsgsd_daemon = "/usr/sbin/kmsgsd";
    my $virgin_kmsgsd_daemon = "/kmsgsd";

    my $diskmond_daemon = "/usr/sbin/diskmond";
    my $virgin_diskmond_daemon = "/diskmond";

    my $psad_init = "/etc/rc.d/init.d/psad";
    my $pre_place_psad_init = "/psad-init";

    my $whois_psad = "/usr/bin/whois.psad";
    my $orig_whois_psad = "/whois";

    ### This has already been put in place by Install.pl.  Now we need to change
    ### to be consistent with the administrator answers with B_replace_line()
    my $psad_conf = "/etc/psad/psad.conf";

    # only do this if the user answered psad questions
    if ( $GLOBAL_CONFIG{$configPrefix}{"psad_config"} eq 'Y' ) {

	&psad_firewall_compatibility;

	# Put the psad daemon in place.
	&B_place($virgin_psad_daemon,$psad_daemon);
	&B_chmod(0500,$psad_daemon);

	# Put the psadwatchd daemon in place.
	&B_place($virgin_psadwatchd_daemon,$psadwatchd_daemon);
	&B_chmod(0500,$psadwatchd_daemon);
	
	# Put the kmsgsd daemon in place.
	&B_place($virgin_kmsgsd_daemon,$kmsgsd_daemon);
	&B_chmod(0500,$kmsgsd_daemon);
	
	# Put the diskmond daemon in place.
	&B_place($virgin_diskmond_daemon,$diskmond_daemon);
	&B_chmod(0500,$diskmond_daemon);

	# Put the psad init script in place (it may be enabled later)
	&B_place($pre_place_psad_init,$psad_init);
	&B_chmod(0500,$psad_init);

	# Put the whois client in place
	&B_place($orig_whois_psad, $whois_psad);

#	my $perl_install_dir = $INC[0];
#	for my $d (@INC) {
#        	if ($d =~ /site_perl\/\d\S+/) {
#                	$perl_install_dir = $d;
#        	}
#	}

#	&B_place("/Psad.pm", "${perl_install_dir}/Psad.pm");

	### make syslog compatible with psad
	&B_append_line("/etc/syslog.conf", "/var/log/psadfifo\n", "kern.info  |/var/log/psadfifo\n");

        # Now, iterate through the answers filling in the script...
        # Strategy:  If and only if the Bastille config file has set a value for a variable
        # that is different from the default, then call B_replace_line() on psad and
        # psad.conf.


	OPTS: for (my $loop=0; $loop < scalar(@psadOptions); ++$loop) {

	    my $ans = $GLOBAL_CONFIG{$configPrefix}{$psadOptions[$loop]{'configname'}};
	    my $variable = $psadOptions[$loop]{'varname'};
            my $defaultval = $psadOptions[$loop]{'default'};
	    my $symbol = '$';

            if ($variable eq "PSAD_ENABLE_AT_BOOT" && $ans eq "Y") {
		&ActionLog("# PSAD.pm: enabling psad with B_chkconfig_on\n");
		&B_chkconfig_on("psad");
            }

            next OPTS unless $ans;  ### if $ans was not set in the config file, then the default value must be in place (it wasn't changed).
#            next OPTS if ($ans eq $defaultval);  ### $ans in the config file is identical to the default value... no need to call B_replace_line()

	    # Figure out which symbol is necessary in front of the var we're assigning
            ### deal with @EMAIL_ADDRESSES array
            if ($variable eq "EMAIL_ADDRESSES") {
		my $pattern = '^(my){0,1}\s*' . '@' . $variable . '\s*=';
		$ans =~ s/,/ /g;   ### get rid of comments between addresses and replace with a space just in case
		my $assignment = 'my @' . $variable . " = qw($ans);\n";  ### psad likes this var scoped with 'my'
		&B_replace_line($psad_daemon, $pattern, $assignment);
		&B_replace_line($psad_conf, $pattern, $assignment);
		&B_replace_line($psadwatchd_daemon, $pattern, $assignment);
		next OPTS;
            }

            ### deal with %DANGER_LEVELS hash
            if ($variable eq "DANGER_LEVELS") {
		my @ans = split /\s+/, $ans;
		for (my $i = 1; $i <= 5; $i++) {
			my $pattern = '^(my){0,1}\s*' . '\\' . '$' . $variable . '{\'' . $i . '\'}' . '\s*=';
			my $assignment = '$' . $variable . '{\'' . $i . '\'}' . " = $ans[$i-1];\n";
			&B_replace_line($psad_daemon, $pattern, $assignment);
			&B_replace_line($psad_conf, $pattern, $assignment);
		}
		next OPTS;
            }

	    my $pattern = '^(my){0,1}\s*' . '\\' . $symbol . $variable . '\s*=';

            my $scope = "";
            if (&getscope($pattern, $psad_daemon)) {
		$scope = "my ";
            }
		
            my $assignment;
            if (&varquoted($pattern, $psad_daemon)) {
	    	$assignment = $scope . $symbol . $variable . " = \"$ans\";\n";
            } else {
		$assignment = $scope . $symbol . $variable . " = $ans;\n";
            }

            ### the config sections from psad_daemon and psad_conf are exactly the same so replace variables in both
            &B_replace_line($psad_daemon, $pattern, $assignment);
            &B_replace_line($psad_conf, $pattern, $assignment);
	} 
    }
    return;
}

sub psad_firewall_compatibility() {
        my $firewall_config_file = "/etc/Bastille/bastille-firewall.cfg";
	my $firewall_init_script = $GLOBAL_DIR{"initd"} . "/bastille-firewall";

        ### since the admin configured psad, we must configure the firewall to log packets that are not explicitly accepted
        my $fwlog_pattern = '^LOG_FAILURES\s*=';
        my $fwlog_assignment = "LOG_FAILURES=\"Y\"\n";
        &B_replace_line($firewall_config_file,$fwlog_pattern,$fwlog_assignment);

        my $fwtcpaudit_pattern = '^TCP_AUDIT_SERVICES\s*=';
        my $fwtcpaudit_assignment = "TCP_AUDIT_SERVICES=\"\"\n";
        &B_replace_line($firewall_config_file,$fwtcpaudit_pattern,$fwtcpaudit_assignment);

        my $fwudpaudit_pattern = '^UDP_AUDIT_SERVICES\s*=';
        my $fwudpaudit_assignment = "UDP_AUDIT_SERVICES=\"\"\n";
        &B_replace_line($firewall_config_file,$fwudpaudit_pattern,$fwudpaudit_assignment);

	### put the pre-audit script in place.  This script is responsible for making the firewall not write log messages
	### for very chatty protocols such as netbios and multicast traffic.
	mkdir "/etc/Bastille/firewall.d", 500;
	mkdir "/etc/Bastille/firewall.d/pre-audit.d", 500;
	&B_place("/bastille-firewall-pre-audit.sh", "/etc/Bastille/firewall.d/pre-audit.d/pre-audit.sh");

	if ( $GLOBAL_CONFIG{'Firewall'}{"ip_enable_firewall"} eq 'Y' ) {
                # run the firewall and enable it with chkconfig
                if ( $GLOBAL_PREFIX eq '' ) {
                    &ActionLog("# PSAD.pm: restarting firewall after PSAD modifications\n");
                    if ( ! (-x $firewall_init_script) ) {
                        &ErrorLog("# PSAD.pm: \"$firewall_init_script\" not executable\n");
                    } else {
                        `$firewall_init_script restart`;
                        if ( $? ne 0 ) {
                            &ErrorLog("# PSAD.pm: error $? invoking \"$firewall_init_script\"\n");
                        }
                    } 
		}
	}
	return;
}
sub getscope() {
	my ($pattern, $file) = @_;
	my $rv = 0;
	open F, "< $file" or return $rv;
	my @lines = <F>;
	close F;
	SCOPE: for my $l (@lines) {
		if ($l =~ /$pattern/ && $l =~ /^\s*my/) {
			$rv = 1;
			last SCOPE;
		}
	}
	return $rv;
}

sub varquoted() {
        my ($pattern, $file) = @_;
        my $rv = 1;	### assume most vars will be quoted
        open F, "< $file" or return $rv;
        my @lines = <F>;
        close F;
        SEARCH: for my $l (@lines) {
                if ($l =~ /$pattern/ && $l =~ /$pattern\s*\".*?\"/) {
                        $rv = 1;
                        last SEARCH;
                } elsif ($l =~ /$pattern/) {
			$rv = 0;
			last SEARCH;
		}
        }
        return $rv;
}

1;

