# Copyright (C) 1999, 2000 Jay Beale
# Copyright (C) 2001 Hewlett Packard
# Licensed under the GNU General Public License

package Bastille::MiscellaneousDaemons;
use lib "/usr/lib";

use Bastille::API;

@ENV="";
$ENV{PATH}="";
$ENV{CDPATH}=".";
$ENV{BASH_ENV}="";



#######################################################################
##                          Miscellaneous Daemons                    ##
#######################################################################

# Deactivate ?standard? services chosen at install, at admin's option.
# Explain why they might want to turn this stuff off.  Remember, most
# newbies will take the, "I don't want to break anything -- turn it all on!"
# approach.  Let's deactivate apmd, portmap, pcmcia, nfs, netfs, smb, 
# dhcpd, amd, gpm, innd, linuxconf, if possible.

&DeactivateAPMD;
&DeactivateRemoteFS;
#&DeactivateATD;
&DeactivatePCMCIA;
&DeactivateDHCP;
&DeactivateGPM;
&DeactivateINND;
&MinimizeChkconfig;
&DeactivateDiagnostic;
&DeactivatePTY;
&DeactivatePwgrd;
&RestrictXaccess;

# If we are running SuSE7.2, we also write to rc.config so that changes are unaltered
# upon reboot of the system. Otherwise, rc.config would overwrite these changes.

#
# Disable non-standard services, which may have been badly chosen at install:
#
# Possibly disable arpwatch, autofs, bootparamd, gated, mars-nwe, mcserv,
# postgresql, routed, rstatd, rusersd, rwalld, rwhod, snmpd, squid, xntpd, 
# ypbind, yppasswdd, ypserv

#
#### WHICH ONES SHOULD WE DISABLE?
#

&DeactivateRoutingDaemons;
&DeactivateNIS;
&DeactivateSNMPD;


sub DeactivateAPMD {

    if (&getGlobalConfig("MiscellaneousDaemons","apmd") eq "Y") {
        &ActionLog("# sub DeactivateAPMD\n");
 
        &B_chkconfig_off ("apmd");
	if ($GLOBAL_DISTRO =~ "^SE") {
        &B_replace_line(&getGlobal('FILE',"rc.config"),'^START_APMD=','START_APMD="no"\n');
	}
}
}

sub DeactivateRemoteFS {

    if (&getGlobalConfig("MiscellaneousDaemons","remotefs") eq "Y") {
	&ActionLog("# sub DeactivateRemoteFS\n");

# For now, we break NFS/SAMBA.  Does someone want to make a "secure?" NFS
# configuration?  Should we allow samba? Can we use samba without the 
# automounter? Are they safe when we don't know if the admin has a firewall?

# question: should we remove the symbolic links for netfs, which
# mounts external net-based drives?
	if ( $GLOBAL_DISTRO =~ "^HP-UX") {
# Kill off processes and change permanant start-up behavior
            &B_ch_rc ("NFS_SERVER", &getGlobal('FILE', 'chkconfig_nfs_server'));
            &B_ch_rc ('NFS_CLIENT',&getGlobal('FILE', 'chkconfig_nfs_client'));
# Just to make sure, turning off, using "nfs core" script
            &B_System (&getGlobal('FILE', 'chkconfig_nfs_core') .
                       " stop",&getGlobal('FILE', 'chkconfig_nfs_core') . " start");
        }
	else {
	ActionLog("# sub DeactivateRemoteFS\n");
 
        &B_chkconfig_off ("portmap");
        &B_chkconfig_off ("nfs");
        &B_chkconfig_off ("smb");
        &B_chkconfig_off ("amd");
	}
	if ($GLOBAL_DISTRO =~ "^SE") {
        &B_replace_line(&getGlobal('FILE',"rc.config"),'^START_PORTMAP','START_PORTMAP="no"\n');
        &B_replace_line(&getGlobal('FILE',"rc.config"),'^NFS_SERVER','NFS_SERVER="no"\n');
        &B_replace_line(&getGlobal('FILE',"rc.config"),'^START_SMB','START_SMB="no"\n');
         }
	if ( $GLOBAL_DISTRO =~ "^HP-UX" ){ #send SIGHUP to inetd to re-read inetd.conf
	    &B_System(&getGlobal('BIN',"inetd") . " -c", &getGlobal('BIN',"inetd") . " -c");
	}
	&B_hash_comment_line(&getGlobal('FILE', "inetd.conf"),"nfs");
	if ( $GLOBAL_DISTRO =~ "^HP-UX" ){ #re-send SIGHUP to reread inetd.conf
	    &B_System(&getGlobal('BIN',"inetd") . " -c", &getGlobal('BIN',"inetd") . " -c");
	}

    }
}


# We disable atd.  All the functionality of at can be mimicked via cron and # there have been large security problems with cron.  
#   if ($GLOBAL_CONFIG{"MiscellaneousDaemons"}{"atd"} eq "Y") {
#   &ActionLog("# sub DeactivateATD\n");
#      &B_chkconfig_off ("atd");
#   if ($GLOBAL_DISTRO =~ "^SE") {
#   &B_replace_line(&getGlobal('FILE',"rc.config"),'^START_ATD','START_ATD="no"\n');
#   }
#   }

sub DeactivatePCMCIA {
 
    # If this isn't a notebook, strongly recommend disabling PCMCIA.
    if ($GLOBAL_CONFIG{"MiscellaneousDaemons"}{"pcmcia"} eq "Y") {
    &ActionLog("# sub DeactivatePCMCI\n");
 
        &B_chkconfig_off ("pcmcia");
    if ($GLOBAL_DISTRO =~ "^SE") { 
    &B_replace_line(&getGlobal('FILE',"rc.config"),'^START_PCMCIA','START_PCMCIA="no"\n');
   }
}
}

sub DeactivateDHCP {
 
    # If this is # If this is not a DHCP server, we deactivate dhcpd.
 
    if ($GLOBAL_CONFIG{"MiscellaneousDaemons"}{"dhcpd"} eq "Y") {
        &ActionLog("# sub DeactivateDHCP\n");
 
        &B_chkconfig_off ("dhcpd");
    if ($GLOBAL_DISTRO =~ "^SE") {
        &B_replace_line(&getGlobal('FILE',"rc.config"),'^IFCONFIG_0="dhcpclient"','IFCONFIG_0=""\n');
    }
}
}

sub DeactivateGPM {
 
    if ($GLOBAL_CONFIG{"MiscellaneousDaemons"}{"gpm"} eq "Y") {
        &ActionLog("# sub DeactivateGPM\n");
 
        &B_chkconfig_off ("gpm");
    if ($GLOBAL_DISTRO =~ "^SE") {
        &B_replace_line(&getGlobal('FILE',"rc.config"),'^START_GPM="yes"','START_GPM="no"\n');
	&ActionLog("# this is where GPM should be edited in rc.config\n");
    }
}
}

sub DeactivateINND {

    # Deactivate innd unless they really need a new server.
	
    if (&getGlobalConfig("MiscellaneousDaemons","innd") eq "Y" ) {
	&ActionLog("# sub DeactivateINND\n");
	
	&B_chkconfig_off ("innd");
   }
    
}


sub DeactivateRoutingDaemons {

    # Disable gated if they're not running a router...  Otherwise, disable 
    # either gated or routed.
    
    &ActionLog("# sub DeactivateRoutingDaemons\n");

    if (&getGlobalConfig("MiscellaneousDaemons","routing") eq "Y") {
	&B_chkconfig_off ("gated");
	&B_chkconfig_off ("routed");
    }
    elsif (&getGlobalConfig("MiscellaneousDaemons","gated") eq "Y") {
	&B_chkconfig_off ("routed");
    }
    else {
	&B_chkconfig_off ("gated");
    }      

}


sub DeactivateNIS {

    # NIS is rather insecure.
    &ActionLog("# sub DeactivateNIS\n");

    if (&getGlobalConfig("MiscellaneousDaemons","nis") eq "Y") {
	if ( $GLOBAL_DISTRO =~ "^HP-UX") {
	    &B_ch_rc ('NIS_MASTER_SERVER',&getGlobal('FILE', 'chkconfig_nis_server'));
	    &B_ch_rc ('NIS_SLAVE_SERVER',&getGlobal('FILE', 'chkconfig_nis_server'));
	    &B_ch_rc ('NIS_CLIENT',&getGlobal('FILE', 'chkconfig_nis_client'));
	    &B_ch_rc ('NISPLUS_SERVER',&getGlobal('FILE', 'chkconfig_nisp_server'));
	    &B_ch_rc ('NISPLUS_CLIENT',&getGlobal('FILE', 'chkconfig_nisp_client'));
	}
	else {
	&B_chkconfig_off ("ypbind");
        &B_chkconfig_off ("ypserv");
        &B_chkconfig_off ("yppasswdd");
    }
	if ($GLOBAL_DISTRO =~ "^SE") {
	&B_replace_line(&getGlobal('FILE',"rc.config"),'^START_YPBIND=','START_YPBIND="no"\n');
}
}
}

sub DeactivateSNMPD {

    # SNMP is rather insecure.  If you need proof, go read the Phrack
    # article or read a bit about the protocol...
    
    if (&getGlobalConfig("MiscellaneousDaemons","snmpd") eq "Y") {
	&ActionLog("# sub DeactivateSNMPD\n");
	unless ( $GLOBAL_DISTRO =~ "^HP-UX") {
	    &B_chkconfig_off ("snmpd");
	}
	else {
	    &B_ch_rc ('SNMP_HPUNIX_START',&getGlobal('FILE', 'chkconfig_snmpd_HP'));
	    &B_ch_rc ('SNMP_MIB2_START',&getGlobal('FILE', 'chkconfig_snmpd_Mib2'));
	    &B_ch_rc ('SNMP_TRAPDEST_START',&getGlobal('FILE', 'chkconfig_snmpd_Trp'));
	    &B_ch_rc ('SNMP_MASTER_START',&getGlobal('FILE', 'chkconfig_snmpd_Master'));
	} # end HP-UX section
    }
}

###
### Should we disable the rest?
###

sub MinimizeChkconfig {

    # This routine is a duplicate of msec's functionality -- it turns
    # off all chkconfig-based services with the exception of those in
    # /etc/security/msec/server.4.

    if (&getGlobalConfig("MiscellaneousDaemons","minimize_chkconfig") eq "Y") {
	&ActionLog("# sub MinimizeChkconfig\n");

	# BUG: GLOBAL_PREFIX is not respected here.
	
	open CHKCONFIGS,"/sbin/chkconfig --list |";
	my $line;
	while ($line = <CHKCONFIGS>) {
	    if ($line =~ /^(.*?)\s+0:/) {
		my $service = $1;
		my $chkconfig_this_off = 1;
		my $allowed_service;
		foreach $allowed_service ( "crond","syslog","keytable","network","gpm","xfs","pcmcia","bastille-firewall") {
		    if ($service eq $allowed_service) {
			$chkconfig_this_off=0;
		    }
		}
		
		if ($chkconfig_this_off) {
		    &B_chkconfig_off($service);
		}
	    }
	}
	close CHKCONFIGS;
    }

}

sub DeactivateDiagnostic {
    if (&getGlobalConfig("MiscellaneousDaemons","disable_diagnostic") eq "Y") {
	&ActionLog("# sub DeactivateDiagnostic\n");
	&B_ch_rc ('DIAGNOSTICS',&getGlobal('FILE', 'chkconfig_diagnostics'));
    }
}

sub DeactivatePTY {
    if (&getGlobalConfig("MiscellaneousDaemons","disable_ptydaemon") eq "Y") {
	&ActionLog("# sub DeactivatePTY\n");
	&B_ch_rc ('VTDAEMON_START',&getGlobal('FILE', 'chkconfig_vt'));
	&B_ch_rc ('PTYDAEMON_START',&getGlobal('FILE', 'chkconfig_pty'));
    }
}

sub DeactivatePwgrd {
   if (&getGlobalConfig("MiscellaneousDaemons","disable_pwgrd") eq "Y") {
	&ActionLog("# sub DeactivatePwgrd\n");
	&B_ch_rc ('PWGR',&getGlobal('FILE', 'chkconfig_pwgrd'));
    }
}

sub RestrictXaccess {
    if (&getGlobalConfig("MiscellaneousDaemons","xaccess") eq "Y") {

	&B_System(&getGlobal('BIN',"dtlogin.rc") . " reset",&getGlobal('BIN',"dtlogin.rc") . " reset");
	&B_create_file (&getGlobal('BFILE', 'Xaccess.bastille'));
	&B_blank_file  (&getGlobal('BFILE', 'Xaccess.bastille'), "Bastille");
	&B_append_line (&getGlobal('BFILE', 'Xaccess.bastille'), "Bastille" ,
			"# This is a blank Xaccess file created by Bastille to prevent \n" .
			"# XDMCP logins.  It is referenced from " . &getGlobal('BFILE', 'Xconfig') . ".\n \n");
	&B_cp(&getGlobal('FILE', 'Xconfig'),&getGlobal('BFILE', 'Xconfig'));
	&B_replace_line(&getGlobal('BFILE', 'Xconfig'), "Dtlogin\.accessFile",
			"Dtlogin\.accessFile:          " .  &getGlobal('BFILE', 'Xaccess.bastille'));
	&B_System(&getGlobal('BIN',"dtlogin.rc") . " reset",&getGlobal('BIN',"dtlogin.rc") . " reset");

    }
}

1;
