<?php
/*
+-------------------------------------------------------------------+
| BasiliX - Copyright (C) 2000 Murat Arslan <arslanm@cyberdude.com> |
+-------------------------------------------------------------------+
*/

// Compose message functions
// ------------------------------------------------------------------


function push_compose_abook() {
    global $RequestID, $lng;
    global $BSX_HTXDIR, $BSX_THEMEDIR, $BSX_VERSION;
    global $BSX_BASEHREF, $BSX_LAUNCHER;

    include("$BSX_HTXDIR/header.htx");
    include("$BSX_HTXDIR/compose-abook.htx");
    include("$BSX_HTXDIR/footer.htx");
}

function push_compose() {
    global $customerID, $RequestID, $sql, $lng;
    global $BSX_HTXDIR, $BSX_THEMEDIR, $BSX_VERSION;
    global $BSX_BASEHREF, $BSX_LAUNCHER;
    global $BSX_SENTMAIL_NAME, $BSX_TRASH_NAME;
    global $SESSID, $BODY_ONLOAD, $is_js, $is_ssl;
    global $abook_items, $abook_items_cnt;
    global $abook_grpitems, $abook_grpitems_cnt;
    global $err_msg, $info_msg;

    global $user_set;	// settings

    global $cmps_fromID, $cmps_fromMsgID, $cmps_fromMbox;
    
    global $cmps_from, $cmps_to, $cmps_cc, $cmps_bcc;
    global $cmps_subject, $cmps_body, $cmps_sign, $cmps_atchlist;

    global $cmps_f0, $cmps_f1, $cmps_f2; global $cmps_s0, $cmps_s1, $cmps_s2;
    global $cmps_c0, $cmps_c1, $cmps_c2;

    if(empty($cmps_from)) $cmps_from = $user_set["name"];

    if(empty($cmps_to))
       $BODY_ONLOAD="onLoad='document.composeMail.cmps_to.focus();'";

    $BODY_ONUNLOAD="onUnLoad='closeWins();'";

    $cwurl = $BSX_BASEHREF . "/" . $BSX_LAUNCHER . "?RequestID=CMPSCLNUP" . "&is_js=" . $is_js . "&is_ssl=" . $is_ssl;
    if($SESSID) $cwurl .= "&SESSID=" . $SESSID;

    if(empty($cmps_atchlist)) $cmps_atchlist = $lng->p(411);

    include("$BSX_HTXDIR/header.htx");
    include("$BSX_HTXDIR/menu.htx");
    include("$BSX_HTXDIR/compose.htx");
    include("$BSX_HTXDIR/footer.htx");
}

function update_atchs() {
	global $cmps_f0, $cmps_s0, $cmps_c0;
	global $cmps_f1, $cmps_s1, $cmps_c1;
	global $cmps_f2, $cmps_s2, $cmps_c2;
	global $lng;

	echo "<script language=\"Javascript\"><!-- //\n";
	if(!empty($cmps_f0))
		$atchbuf = $cmps_f0 . " (" . convert_size($cmps_s0) . ")";
	else
		$atchbuf = $lng->p(411);
	if(!empty($cmps_f1))
		$atchbuf .= ", " . $cmps_f1 . " (" . convert_size($cmps_s1) . ")";
	if(!empty($cmps_f2))
		$atchbuf .= ", " . $cmps_f2 . " (" . convert_size($cmps_s2) . ")";

	echo "window.opener.document.composeMail.elements[\"cmps_f0\"].value=\"" . htmlspecialchars($cmps_f0) . "\";\n";
	echo "window.opener.document.composeMail.elements[\"cmps_s0\"].value=\"" . $cmps_s0 . "\";\n";
	echo "window.opener.document.composeMail.elements[\"cmps_c0\"].value=\"" . $cmps_c0 . "\";\n";
	echo "window.opener.document.composeMail.elements[\"cmps_f1\"].value=\"" . htmlspecialchars($cmps_f1) . "\";\n";
	echo "window.opener.document.composeMail.elements[\"cmps_s1\"].value=\"" . $cmps_s1 . "\";\n";
	echo "window.opener.document.composeMail.elements[\"cmps_c1\"].value=\"" . $cmps_c1 . "\";\n";
	echo "window.opener.document.composeMail.elements[\"cmps_f2\"].value=\"" . htmlspecialchars($cmps_f2) . "\";\n";
	echo "window.opener.document.composeMail.elements[\"cmps_s2\"].value=\"" . $cmps_s2 . "\";\n";
	echo "window.opener.document.composeMail.elements[\"cmps_c2\"].value=\"" . $cmps_c2 . "\";\n";
	echo "window.opener.document.composeMail.elements[\"cmps_atchlist\"].value=\"" . $atchbuf . "\";\n";

	echo "// --></script>\n";
}

function push_jsaddrs() {
	global $abook_items_cnt, $abook_grpitems_cnt;
	global $abook_items, $abook_grpitems;

	echo "<script language=\"JavaScript\"><!-- //\n";
	if($abook_items_cnt) {
		echo "var addrNicks = new Array();\n";
		echo "var addrNames = new Array();\n";
		echo "var addrMails = new Array();\n";
		echo "var addrGrpMembers = new Array();\n";
		echo "var addrGrpNames = new Array();\n";
		$glue = "";
		$str = "";
		for($i = 0 ; $i < $abook_items_cnt ; $i++) {
			$str = "$str$glue" . $abook_items[$i]["id"];
			$glue = ",";
			echo "addrNames[" . $abook_items[$i]["id"] . "] = \"" . addslashes($abook_items[$i]["name"]) . "\";\n";
			echo "addrNicks[" . $abook_items[$i]["id"] . "] = \"" . addslashes($abook_items[$i]["nick"]) . "\";\n";
			echo "addrMails[" . $abook_items[$i]["id"] . "] = \"" . $abook_items[$i]["email"] . "\";\n";
		}
		echo "var addr_items=\"" . $str . "\";\n";
		$glue = "";
		$str = "";
		for($i = 0 ; $i < $abook_grpitems_cnt ; $i++) {
			$str = "$str$glue" . $abook_grpitems[$i]["id"];
			$glue = ",";
			echo "addrGrpMembers[" . $abook_grpitems[$i]["id"] . "] = \"" . $abook_grpitems[$i]["member"] . "\";\n";
			echo "addrGrpNames[" . $abook_grpitems[$i]["id"] . "] = \"" . addslashes($abook_grpitems[$i]["grpname"]) . "\";\n";
		}
		echo "var addr_grpitems=\"" . $str . "\";\n";
	}
	echo "// --></script>\n";
}

function compose_rmatchs() {
	global $atch_dir;

	for($i = 0 ; $i < 3 ; $i++) {
		$tmp_f = "cmps_f" . $i; $tmp_file = $$tmp_f;
                $tmp_filepath = $atch_dir . "/" . $tmp_file;
                if(!empty($tmp_file) && file_exists($tmp_filepath)) {
		   $tmp_remove = "/bin/rm -f $tmp_filepath";
		   @passthru($tmp_remove);
		}
	}
}

function prepare_data($d) {
	$nd = ereg_replace("\r", "", $d);
	$nd = ereg_replace("\n", "\r\n", $nd);
	return $nd;
}


function compose_sendmail() {
	global $BSX_ATTACH_DIR, $BSX_VERSION;
	global $BSX_BASEHREF, $BSX_LAUNCHER, $BSX_LIBDIR;
	global $BSX_HTXDIR, $BSX_THEMEDIR, $BSX_SENTMAIL;
	global $BSX_SENTMAIL_NAME, $BSX_TRASH_NAME, $BSX_MDIR;
	global $SESSID, $BODY_ONLOAD, $is_js, $is_ssl;

	global $customerID, $RequestID, $sql, $imap, $lng, $user_set;
	global $bsx_domains, $domain_name, $domain, $username, $password;

	global $cmps_f0, $cmps_s0, $cmps_c0;
	global $cmps_f1, $cmps_s1, $cmps_c1;
	global $cmps_f2, $cmps_s2, $cmps_c2;

	global $cmps_fromID, $cmps_fromMsgID, $cmps_fromMbox;

	global $info_msg, $err_msg;

	global $cmps_from, $cmps_to, $cmps_cc, $cmps_bcc;
	global $cmps_subject, $cmps_body, $cmps_sign, $cmps_atchlist;

	global $cmps_to_arr, $cmps_cc_arr, $cmps_bcc_arr;

	include("$BSX_HTXDIR/header.htx");

	// generate header
	$atch_dir = $BSX_ATTACH_DIR . "/" .  "$domain_name" . "/" . "$username";
	$msg_header = "";
	if(!empty($cmps_fromMsgID)) 
	   $msg_header .= "In-Reply-To: $cmps_fromMsgID\r\n";
	$msg_header .= "Message-ID: <BasiliX-" .$BSX_VERSION . "-" . uniqid(time()) . "@" . trim(`hostname --fqdn`) . ">\r\n";
	$msg_header .= "X-Mailer: BasiliX " . $BSX_VERSION . " -- http://basilix.org\r\n";
	$msg_header .= "X-SenderIP: " . $GLOBALS["REMOTE_ADDR"] . "\r\n";
	$msg_header .= "Date: " . date("D, d M Y H:i:s T", time()) . "\r\n";
	$msg_header .= "From: " . $cmps_from . " <" . $username . "@" . $domain_name . ">\r\n";
	$cmps_subject = empty($cmps_subject) ? "(no subject)" : $cmps_subject;
	$msg_header .= "Subject: " . $cmps_subject . "\r\n";


	// all recipients
	$msg_rcpt = array();
	$msg_rcpt_cnt = 0;
	$tmp_token = chr(02);
	if(!empty($cmps_to_arr)) {
		for($j = 0 ; $j < count($cmps_to_arr) ; $j++) {
 		   $msg_header .= "To: " . trim($cmps_to_arr[$j]) . "\r\n";
		   $tmp_to2 = eregi_replace("([A-Za-z0-9._-]+\@[[:alnum:].[a-zA-Z0-9_-]+[a-zA-Z]+)",
					"$tmp_token\\1$tmp_token", trim($cmps_to_arr[$j]));
		   $tmp_to2_arr = explode($tmp_token, $tmp_to2);
		   if(count($tmp_to2_arr) != 3) continue;	// hmm?
		   $msg_rcpt[$msg_rcpt_cnt++] = $tmp_to2_arr[1];
		}
	}
	if(!empty($cmps_cc_arr)) {
		for($j = 0 ; $j < count($cmps_cc_arr) ; $j++) {
		   $msg_header .= "Cc: " . trim($cmps_cc_arr[$j]) . "\r\n";
		   $tmp_cc2 = eregi_replace("([A-Za-z0-9._-]+\@[[:alnum:].[a-zA-Z0-9_-]+[a-zA-Z]+)",
					"$tmp_token\\1$tmp_token", trim($cmps_cc_arr[$j]));
		   $tmp_cc2_arr = explode($tmp_token, $tmp_cc2);
		   if(count($tmp_cc2_arr) != 3) continue;
		   $msg_rcpt[$msg_rcpt_cnt++] = $tmp_cc2_arr[1];
		}
	}
	if(!empty($cmps_bcc_arr)) {
		for($j = 0 ; $j < count($cmps_bcc_arr) ; $j++) {
		   $msg_header .= "Bcc: " . trim($cmps_bcc_arr[$j]) . "\r\n";
		   $tmp_bcc2 = eregi_replace("([A-Za-z0-9._-]+\@[[:alnum:].[a-zA-Z0-9_-]+[a-zA-Z]+)",
					"$tmp_token\\1$tmp_token", trim($cmps_bcc_arr[$j]));
		   $tmp_bcc2_arr = explode($tmp_token, $tmp_bcc2);
		   if(count($tmp_bcc2_arr) != 3) continue;
		   $msg_rcpt[$msg_rcpt_cnt++] = $tmp_bcc2_arr[1];
		}
	}

	// include signature
	if($cmps_sign) $cmps_body .= "\r\n" . $user_set["sign"];

	// generate attachments
	$msg_boundary = md5(uniqid(time())) . "-" . time();
	$msg_body = "";
	if(!empty($cmps_f0)) {
		$msg_header .= "MIME-Version: 1.0\r\n";
		$msg_header .= "Content-Type: multipart/mixed; boundary=\"" . $msg_boundary . "\"\r\n\r\n";
		$msg_header .= "--" . $msg_boundary . "\r\n";
		$msg_header .= "Content-Type: text/plain\r\n\r\n";
		$msg_header .= $cmps_body . "\r\n\r\n";
	}

	$atched = 0;
	for($i = 0 ; $i < 3 ; $i++) {
		$tmp_f = "cmps_f" . $i;	$tmp_c = "cmps_c" . $i;
		$tmp_file = $$tmp_f; $tmp_content = $$tmp_c;
		$tmp_filepath = $atch_dir . "/" . $tmp_file;

		if(!empty($tmp_file) && file_exists($tmp_filepath)) {
			$tmp_fp = fopen($tmp_filepath, "r");
			$tmp_filein = fread($tmp_fp, filesize($tmp_filepath));
			fclose($tmp_fp);
			$msg_header .= "--" . $msg_boundary . "\r\n";
			if(empty($tmp_content)) $tmp_content = "application/octet-stream";
			else $tmp_content = strtolower($tmp_content);
			$msg_header .= "Content-Type: " . $tmp_content . "\r\n";
			$tmp_filein = chunk_split(base64_encode($tmp_filein), 60);
			$msg_header .= "Content-Transfer-Encoding: base64\r\n";
			$msg_header .= "Content-Description: $tmp_file\r\n";
			$tmp_type = strtok($tmp_content, "/");
			if($tmp_type == "image") $tmp_disp = "inline";
			else $tmp_disp = "attachment";
			$msg_header .= "Content-Disposition: " . $tmp_disp . "; filename=\"" . $tmp_file . "\"\r\n\r\n";
			$msg_header .= $tmp_filein;

			$atched = 1;
		}
	}
	if($atched) {
		$msg_header .= "--" . $msg_boundary . "--\r\n";
	} else {
		$msg_body = "\r\n" . $cmps_body . "\r\n";
	}


	// here we go
	require("$BSX_LIBDIR/smtp.class");
	
	$SMTP_HOST = $bsx_domains["$domain"]["smtp_host"];
	$smtp = new SMTP($SMTP_HOST);

	// debug
	// $smtp->togdebug();
	
	$rc = $smtp->connect();
	if(!rc) {
	   switch($rc) {
		case -4:
			err_exit($lng->p(455));
		case -5:
			err_exit($lng->p(456));
		default:
			err_exit($lng->p(457));
	    }
        }
	// prepare the datas
	$msg_header = prepare_data($msg_header);
	$msg_body = prepare_data($msg_body);

	// ok send it
	if(!($smtp->mailfrom("<" . $username . "@" . $domain_name . ">")
	   && $smtp->rcptall($msg_rcpt)
	   && $smtp->startdata()
	   && $smtp->senddata($msg_header)
	   && $smtp->senddata($msg_body)
	   && $smtp->stopdata()
	   && $smtp->disconnect())) {
		$msg_errno = $smtp->geterr(&$msg_error, &$msg_srverror);
		$err_msg = "SMTP Error $msg_errno:<br>";
		$err_msg .= "Error Message is: " . htmlspecialchars($msg_error) . "<br>";
		$err_msg .= "Server $SMTP_HOST replied: " . $msg_srverror . "<br>\n";
		$ok_sent = false;
	} else {
		compose_rmatchs();	// no longer needed..
		$ok_sent = true;
		$info_msg = $lng->p(444);

		require("$BSX_LIBDIR/imap2.inc");
		// set Answered flag
		if(strtoupper($cmps_fromMbox) != "INBOX")
		   $imap->reopbox($BSX_MDIR . "/" . $cmps_fromMbox);
		$imap->setflg($cmps_fromID, "\\Answered");

		// append to sent mail
	        $imap->reopbox($BSX_SENTMAIL);
		$imap->apnd($BSX_SENTMAIL, $msg_header . "\r\n\r\n" . $msg_body);
	}

	include("$BSX_HTXDIR/menu.htx");
	include("$BSX_HTXDIR/compose-finalinfo.htx");
	include("$BSX_HTXDIR/footer.htx");
}

function reply_data($d) {
	$d = "> " . $d;				// put a leading "> "
	$nd = ereg_replace("\r", "", $d);
	$nd = ereg_replace("\n", "\r\n> ", $nd);
	$nd = substr($nd, 0, strlen($nd) - 2);	// get rid of trailing "> "
	return $nd;
}

require("$BSX_LIBDIR/readmsg.inc");
function get_reply($what = 0) { // 0 (default) = reply, 1 = reply all, 2 = forward
    global $BSX_MDIR, $BSX_ATTACH_DIR, $BODY_ONLOAD, $ID, $mbox;
    global $cmps_to, $cmps_cc, $cmps_subject, $cmps_body;
    global $err_msg, $info_msg, $body_type;
    global $lng, $imap, $username, $domain_name;
    global $cmps_fromID, $cmps_fromMsgID, $cmps_fromMbox;

    global $cmps_f0, $cmps_s0, $cmps_c0;
    global $cmps_f1, $cmps_s1, $cmps_c1;
    global $cmps_f2, $cmps_s2, $cmps_c2;

    global $cmps_atchlist;

    // --
    if(strtoupper($mbox) != "INBOX")
      if(!$imap->reopbox($BSX_MDIR . "/" . $mbox)) return;
    // -
    
    $mbox_info = $imap->mboxinfo();
    $msg_no = $imap->msgno($ID);
    if(!$msg_no) {
        $err_msg = $lng->p(445);
        return;
    }

    $msg_header = $imap->msghdr($msg_no);
    $msg_str = $imap->ftchstr($msg_no);

    $reply_obj = $msg_header->reply_to[0];

    if(is_object($reply_obj)) {
       $reply_addr = $reply_obj->mailbox . "@" . strtolower($reply_obj->host);
       if(empty($reply_obj->personal))
          $msg_from = $reply_addr;
       else
          $msg_from = decode_mime($reply_obj->personal) . " <$reply_addr>";
    } else {
       $msg_from = $lng->p(7);
    }

    $cmps_to = $msg_from;
    $my_addr = $username . "@" . strtolower($domain_name);
    $glue = ",";

	
    if($what == 1) { // replying to all
	// generate "to"
	for($i = 0 ; $i < count($msg_header->to) ; $i++) {
	    $to_obj = $msg_header->to[$i];
	    if(is_object($to_obj)) {
	       $to_addr = $to_obj->mailbox . "@" . strtolower($to_obj->host);
	       if($to_addr == $my_addr) continue;
	       if(empty($to_obj->personal))
		  $msg_to = $to_addr;
	       else
		  $msg_to = decode_mime($to_obj->personal) . " <$to_addr>";
	       $cmps_to .= $glue . $to_addr;
	    }
	}
	$cmps_cc = "";
	$glue = "";
	// and "cc"
	for($i = 0 ; $i < count($msg_header->cc) ; $i++) {
	    $cc_obj = $msg_header->cc[$i];
	    if(is_object($cc_obj)) {
	       $cc_addr = $cc_obj->mailbox . "@" . strtolower($cc_obj->host);
	       if($cc_addr == $my_addr) continue;
	       if(empty($cc_obj->personal))
		  $msg_cc = $cc_addr;
	       else
		  $msg_cc = decode_mime($cc_obj->personal) . " <$cc_addr>";
	       $cmps_cc .= $glue . $cc_addr;
	       $glue = ",";
	    }
	}
    }
    
    if($what == 2 && check_atch($msg_no) == true) { // get the attachments (max 3 of them)
        $atch_dir = $BSX_ATTACH_DIR . "/" .  "$domain_name" . "/" . "$username";
	$cmd = "/bin/mkdir -p $atch_dir";
	@exec($cmd);

        for($i = 1 ; $i <= count($msg_str->parts) && $i < 4; $i++) {
		$j = $i - 1;
                $tmp_f = "cmps_f" . $j; $tmp_c = "cmps_c" . $j; $tmp_s = "cmps_s" . $j;
		$tmp_type="";$tmp_subtype="";$tmp_file="";$tmp_filepath="";

		// attachment part
		$atch_part = $msg_str->parts[$i];
		if(!is_object($atch_part)) continue;
		
		// content type
		$tmp_type = $body_type[$atch_part->type];
		$tmp_subtype = strtolower($atch_part->subtype);
		if(empty($tmp_subtype)) $tmp_subtype = "x-unknown";
		$tmp_content = $tmp_type . "/" . $tmp_subtype;

		if(empty($tmp_type)) {
		   switch($tmp_subtype) {
			case "html":
			case "plain":
			case "enriched":
			    $tmp_type = "text";
			    break;
			case "rfc822":
			case "delivery-status":
			    $tmp_type = "message";
			    break;
			default:
			$tmp_type = "application";
			    break;
		    }
		}
		// filename
		if($atch_part->ifparameters) {
		   while(list(, $atch_param) = each($atch_part->parameters)) {
			switch(strtolower($atch_param->attribute)) {
			    case "filename":
			    case "name":
				$tmp_file = $atch_param->value;
				break;
			}
		   }
		}
		if($atch_part->ifdparameters) {
		   while(list(, $atch_param) = each($atch_part->dparameters)) {
			switch(strtolower($atch_param->attribute)) {
			    case "filename":
			    case "name":
				$tmp_file = $atch_param->value;
				break;
			}
		   }
		}
		if(empty($tmp_file)) {
		    switch($tmp_subtype) {
			case "html":
				$tmp_file = "message.html";
				break;
                	case "rfc822":
                    		$tmp_file = "message.txt";
                    		break;
                	case "delivery-status":
                    		$tmp_file = "message.txt";
                    		break;
                	case "plain":
                    		$tmp_file = "message.txt";
                    		break;
                	case "enriched":
                    		$tmp_file = "message.rtf";
                    		break;
                	case "pgp-signature":
                    		$tmp_file = "pgp-signature.txt";
                    		break;
            	    }
    		}
                $tmp_filepath = $atch_dir . "/" . $tmp_file;

		// the file itself
		$tmp_encoding = $atch_part->encoding;
		$tmp_encfunc = "enc_func" . $tmp_encoding;
		$atch_body = $imap->ftchbody($msg_no, $i + 1);
		$tmp_filein = $tmp_encfunc($atch_body);

		// ok copy and ready the file there
		$fp = fopen($tmp_filepath, "wb");
		if(!$fp) continue; // wtf?
		fwrite($fp, $tmp_filein);
		fclose($fp);
		$tmp_size = filesize($tmp_filepath);

		// finally set variables
		$$tmp_s = $tmp_size;
		$$tmp_c = $tmp_content;
		$$tmp_f = $tmp_file;
	}
    }		  
	
    if(!empty($cmps_f0))
	$cmps_atchlist = $cmps_f0 . " (" . convert_size($cmps_s0) . ")";
    if(!empty($cmps_f1))
	$cmps_atchlist .= ", " . $cmps_f1 . " (" . convert_size($cmps_s1) . ")";
    if(!empty($cmps_f2))
	$cmps_atchlist .= ", " . $cmps_f2 . " (" . convert_size($cmps_s2) . ")";

    $msg_body = check_body($msg_no, $ID, $imap->ftchbody($msg_no, 1));
    $msg_date = date("d M Y H:i T", $msg_header->udate);
    $msg_subject = $msg_header->subject;

    if($what == 0 || $what == 1) {
        $lng->sb(446); $lng->sr("%d", $msg_date); $wrote_str = $lng->sp();
	$cmps_subject = "Re: " . decode_mime($msg_subject);
        $cmps_body = $wrote_str . "\r\n\r\n" . reply_data($msg_body);
        $cmps_fromID = $ID;
        $cmps_fromMsgID = $msg_header->message_id;
	$cmps_fromMbox = $mbox;

	$BODY_ONLOAD="onLoad='document.composeMail.cmps_body.focus();'";
    } else {
	$fwd_str = $lng->p(447);
	$lng->sb(448); $lng->sr("%d", $msg_date); $date_str = $lng->sp();
	$lng->sb(449); $lng->sr("%f", $msg_from); $from_str = $lng->sp();
	$lng->sb(450); $lng->sr("%s", $msg_subject); $subj_str = $lng->sp();
	$cmps_subject = "Fwd: " . decode_mime($msg_subject);
        $cmps_body = $fwd_str . "\r\n" . $date_str . "\r\n" . $from_str . "\r\n" . $subj_str . "\r\n\r\n" . prepare_data($msg_body);

	// since we'll forward, empty the "To" part and focus
	$cmps_to = "";
	$BODY_ONLOAD="onLoad='document.composeMail.cmps_to.focus();'";
    }
}
?>
