/****************************************************************************
** $Id:  qt/main.cpp   3.0.0   edited Jun 1 18:44 $
**
** Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
** This file is part of an example program for Qt.  This example
** program may be used, distributed and modified without limitation.
**
*****************************************************************************/

#include <qapplication.h>
#include <qtable.h>
#include <stdio.h>
// Table size

// doesn't work with Qt2.0 if using to many rows

const int numRows = 800;
const int numCols = 5;

class MyTable : public QTable
{
public:
    MyTable( int r, int c ) : QTable( r, c ) {
	items.setAutoDelete( TRUE );
	widgets.setAutoDelete( TRUE );
	setCaption( tr( "This is a big table with..." ) );
	setLeftMargin( fontMetrics().width( "W999999W" ) );
    }

    void resizeData( int ) {
	printf("RESIZEDATA\n");
    }
    QTableItem *item( int r, int c ) const {
	return items.find( indexOf( r, c ) );
    }
    void setItem( int r, int c, QTableItem *i ) {
        printf("SETITEM %d %d\n", r, c);
	items.replace( indexOf( r, c ), i ); }
    void clearCell( int r, int c ) {
        printf("CLEARCELL %d %d\n", r, c);
	items.remove( indexOf( r, c ) ); }
    void insertWidget( int r, int c, QWidget *w ) {
        printf("INSERTWIDGET %d %d\n", r, c);
	widgets.replace( indexOf( r, c ), w );
    }
    QWidget *cellWidget( int r, int c ) const {
	return widgets.find( indexOf( r, c ) ) }
    void clearCellWidget( int r, int c ) {
	printf("CLEARWIDGET %d %d\n", r, c);
	widgets.remove( indexOf( r, c ) );
    }
    void updateCell( int r, int c ) {
	printf("UpdateCell %d %d\n", r, c);
    }

private:
    QIntDict<QTableItem> items;
    QIntDict<QWidget> widgets;
};

// The program starts here.

int main( int argc, char **argv )
{
    QApplication app( argc, argv );			

    MyTable table( numRows, numCols );
    app.setMainWidget( &table );
    table.show();
    return app.exec();
}
