// Copyright 2000 by Kevin Atkinson under the terms of the LGPL

#include "invalid_flag.hh"
#include "app_string.hh"
#include "data.hh"

namespace aspell {

  void InvalidFlag::add_message() {
    message += "The flag \":";
    message += flag;
    message += "\" found after \"";
    message += word;
    message += "\" is invalid.";
  }
  
  InvalidFlag::InvalidFlag(const string & w, const string & fl) 
    : word(w), flag(fl)
  {
    add_message();
  }
  
  void InvalidFlag::rethrow_w_file(const string & f) const {
    abort();
  }

  void ConflictingFlags::add_message() {
    message += "The word \"";
    message += word;
    message += "\" appeared in the word list more than once. "
      "Unfortunately when it first appeared it had the flag \"";
    message += flag1;
    message += "\" which conflicts with the flag \"";
    message += flag2;
    message += "\" found after this instance of the word.";
  }
  
  ConflictingFlags::ConflictingFlags(const string & w, 
				     CompoundInfo f1,
				     CompoundInfo f2,
				     const Language & l)
    : word(w)
  {
    {
      AppString s(&flag1);
      f1.write(s,l);
    } {
      AppString s(&flag2);
      f2.write(s,l);
    }
    add_message();
  }
  
  void ConflictingFlags::rethrow_w_file(const string & f) const {
    abort();
  }

}
