#ifndef __sgml_skip__
#define __sgml_skip__

#include <vector>

#include "skip.hh"
#include "refcount.hh"
#include "string_map.hh"

namespace afilter {

  template <typename T>
  class TeXSkip : public T::Base {
  public:
    typedef typename T::Base      Base;
    typedef typename T::Itr       Itr;
    typedef typename T::ItrRoot   ItrRoot;

    enum InWhat {Name, Opt, Parm, Other, Swallow};
    struct Command {
      InWhat in_what;
      string name;
      const char * do_check;
      Command(InWhat w) : in_what(w), do_check("P") {}
    };
  private:
    bool in_comment;
    bool prev_backslash;
    vector<Command> stack;

    class Commands : public StringMap {
      bool add   (const char *);
      bool remove(const char *);
    };
    struct Parms {
      Commands commands;
      bool check_comments;
    };
    RefCount<Parms> parms;
    
    inline void push_command(InWhat);
    inline void pop_command();

    bool end_option(char u, char l);
  public:
    TeXSkip() {abort();}
    TeXSkip(ConfigData &); 
  
    string name() const {return "tex";}
    double order_num() const {return .35;} 
  
    bool skip(char c, const Itr *);
  };
}

#endif
