------------------------------------------------------------------------------
--                                                                          --
--                      GNAT METRICS TOOLS COMPONENTS                       --
--                                                                          --
--                  M E T R I C S . E N V I R O N M E N T                   --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                   Copyright (C) 2003-2004, ACT Europe                    --
--                                                                          --
-- GNAT Metrics Toolset  is free software;  you can  redistribute it and/or --
-- modify it under terms of the  GNU General Public License as published by --
-- the Free Software Foundation;  either version 2, or (at your option) any --
-- later version.  GNAT Metrics Toolset is  distributed in the hope that it --
-- will be useful, but  WITHOUT ANY WARRANTY; without even the implied war- --
-- ranty of  MERCHANTABILITY or  FITNESS FOR A PARTICULAR PURPOSE.  See the --
-- GNU General Public License for more details.  You should have received a --
-- copy of the  GNU General Public License distributed with  GNAT; see file --
-- COPYING.  If not,  write to the  Free  Software  Foundation,   59 Temple --
-- Place - Suite 330, Boston,                                               --
--                                                                          --
-- GNAT Metrics Toolset is maintained by ACT Europe                         --
-- (http://www.act-europe.fr).                                              --
--                                                                          --
------------------------------------------------------------------------------

--  This package defines data structures and routines for setting up and
--  controlling the Metrics Toolset, such as argument tables, routines for
--  initialization, cleaning up, resetting etc.

with GNAT.OS_Lib;          use GNAT.OS_Lib;

with METRICS.Source_Table; use METRICS.Source_Table;

package METRICS.Environment is

   procedure Initialize;
   --  This procedure scans the tool command-line parameters and set all the
   --  tool control parameters. It also fills in the source file table
   --  Raises Fatal_Error if the results of initialization make meaningless
   --  any further processing. It also creates a temporary directory and
   --  moves into it.

   procedure Clean_Up;
   --  Performs the final clean-up actions, including closing and deleting of
   --  all files that should be closed or deleted.

   procedure Source_Clean_Up (SF : SF_Id);
   --  Minimal clean-up needed for one source (basically, closing and
   --  dissociating the Context).

   Temp_Dir : String_Access;
   --  Contains the name of the temporary directory created by the metric tools
   --  for the tree files

end METRICS.Environment;
