------------------------------------------------------------------------------
--                                                                          --
--                          GNATCHECK COMPONENTS                            --
--                                                                          --
--                     G N A T C H E C K . D R I V E R                      --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                     Copyright (C) 2004-2007, AdaCore                     --
--                                                                          --
-- GNATCHECK  is  free  software;  you can redistribute it and/or modify it --
-- under terms of the  GNU  General Public License as published by the Free --
-- Software Foundation;  either version 2, or ( at your option)  any  later --
-- version.  GNATCHECK  is  distributed in the hope that it will be useful, --
-- but  WITHOUT  ANY  WARRANTY;   without  even  the  implied  warranty  of --
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General --
-- Public License for more details.  You should have received a copy of the --
-- GNU  General Public License distributed with GNAT; see file  COPYING. If --
-- not,  write to the  Free Software Foundation,  51 Franklin Street, Fifth --
-- Floor, Boston, MA 02110-1301, USA.                                       --
--                                                                          --
-- GNATCHECK is maintained by AdaCore (http://www.adacore.com).             --
--                                                                          --
------------------------------------------------------------------------------

with Ada.Command_Line;

with Asis.Exceptions;

with ASIS_UL.Common;
with ASIS_UL.Output;

with ASIS_UL.Environment;
with ASIS_UL.Source_Table.Gnatcheck_Processing;

with Namet;
with Snames;

procedure Gnatcheck.Driver is
   --  For the current state of the Asis Utility Library, GNATCHECK seems to be
   --  too complicated to be based on some standard driver. The main problem is
   --  that at some point we will have to add processing of the compiler
   --  warnings that goes beyond the typical framework for the ASIS processing.
begin
   --  The following allows to use the front-end Snames routines when analyzing
   --  rule parameters
   Namet.Initialize;
   Snames.Initialize;

   ASIS_UL.Environment.Initialize;
   ASIS_UL.Source_Table.Gnatcheck_Processing.Initialize;
   ASIS_UL.Source_Table.Gnatcheck_Processing.Process_Sources;
   ASIS_UL.Source_Table.Gnatcheck_Processing.Finalize;
   ASIS_UL.Environment.Clean_Up;
exception
   when ASIS_UL.Common.Fatal_Error =>
      --  Just a trap; all the diagnostic messages should already
      --  have been generated.
      Ada.Command_Line.Set_Exit_Status (Ada.Command_Line.Failure);
      ASIS_UL.Environment.Clean_Up;

   when Ex : Asis.Exceptions.ASIS_Inappropriate_Context          |
             Asis.Exceptions.ASIS_Inappropriate_Container        |
             Asis.Exceptions.ASIS_Inappropriate_Compilation_Unit |
             Asis.Exceptions.ASIS_Inappropriate_Element          |
             Asis.Exceptions.ASIS_Inappropriate_Line             |
             Asis.Exceptions.ASIS_Inappropriate_Line_Number      |
             Asis.Exceptions.ASIS_Failed                         =>

      Ada.Command_Line.Set_Exit_Status (Ada.Command_Line.Failure);
      ASIS_UL.Output.Report_Unhandled_ASIS_Exception (Ex);
      ASIS_UL.Environment.Clean_Up;

   when Ex : others =>
      Ada.Command_Line.Set_Exit_Status (Ada.Command_Line.Failure);
      ASIS_UL.Output.Report_Unhandled_Exception (Ex);
      ASIS_UL.Environment.Clean_Up;

   null;
end Gnatcheck.Driver;
