------------------------------------------------------------------------------
--                                                                          --
--                          GNATCHECK COMPONENTS                            --
--                                                                          --
--  A S I S _ U L . E N V I R O N M E N T . S C A N _ P A R A M E T E R S   --
--                                                                          --
--            (adapted for gnatcheck from ASIS Utility Library)             --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                     Copyright (C) 2004-2006, AdaCore                     --
--                                                                          --
-- GNATCHECK  is  free  software;  you can redistribute it and/or modify it --
-- under terms of the  GNU  General Public License as published by the Free --
-- Software Foundation;  either version 2, or ( at your option)  any  later --
-- version.  GNATCHECK  is  distributed in the hope that it will be useful, --
-- but  WITHOUT  ANY  WARRANTY;   without  even  the  implied  warranty  of --
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General --
-- Public License for more details.  You should have received a copy of the --
-- GNU  General Public License distributed with GNAT; see file  COPYING. If --
-- not,  write to the  Free Software Foundation,  51 Franklin Street, Fifth --
-- Floor, Boston, MA 02110-1301, USA.                                       --
--                                                                          --
-- GNATCHECK is maintained by AdaCore (http://www.adacore.com).             --
--                                                                          --
------------------------------------------------------------------------------

with Ada.Strings.Fixed;

with GNAT.Command_Line;          use GNAT.Command_Line;

with ASIS_UL.Options;            use ASIS_UL.Options;
with ASIS_UL.Source_Table;       use ASIS_UL.Source_Table;

with Gnatcheck.Diagnoses;
with Gnatcheck.Options;          use Gnatcheck.Options;
with Gnatcheck.Output;           use Gnatcheck.Output;
with Gnatcheck.Rules.Rule_Table; use Gnatcheck.Rules.Rule_Table;

separate (ASIS_UL.Environment)
procedure Scan_Parameters is
   No_More_Args : Boolean := True;
   Success      : Boolean;

   procedure Process_Sections;
   --  Processes option sections. At the moment we have two such sections -
   --  'cargs' for compiler arguments and 'rules' for switching rules ON and
   --  OFF and changing the rule status to feature detection.

   procedure Process_Sections is
   begin

      Process_cargs_Section;

      --  Processing the 'rules' section
      Goto_Section ("rules");

      loop
         case GNAT.Command_Line.Getopt ("* from=") is
         --  We do not want to depend on the set of the currently implemented
         --  rules
            when ASCII.NUL =>
               exit;
            when 'f' =>
               Process_Rule_File (Parameter);
            when others =>
               Process_Rule_Option
                 (Ada.Strings.Fixed.Trim (Full_Switch, Ada.Strings.Both));
               --  We use the call to Trim here because there can be a rule
               --  option in quotation marks
         end case;
      end loop;

   end Process_Sections;
begin
   Turn_All_Rules_On;
   Turn_All_Global_Rules_Off;
   --  This is for the first demo only!!!

   Initialize_Option_Scan
     (Stop_At_First_Non_Switch => True,
      Section_Delimiters       => "cargs rules");

   loop
      case GNAT.Command_Line.Getopt
        ("v d dd q h s? l files= a "&
         "gnat05")                   --  Ada 2005 mode)
      is

         when ASCII.NUL =>
            exit;
         when 'a' =>

            if Full_Switch = "a" then
               Process_RTL_Units := True;
            end if;

         when 'd' =>

            if Full_Switch = "d" then
               Debug_Mode := True;
            elsif Full_Switch = "dd" then
               Progress_Indicator_Mode := True;
            end if;

         when 'f' =>

            if Full_Switch = "files" then
               Read_Args_From_File (Parameter);
            end if;

         when 'h' =>
            if Full_Switch = "h" then
               Generate_Rules_Help := True;
            end if;

         when 'g' =>

            if Full_Switch = "gnat05" then
               ASIS_UL.Options.ASIS_2005_Mode := True;
            end if;

         when 'l' =>
            Gnatcheck.Options.Full_Source_Locations := True;

         when 'q' =>
            Quiet_Mode := True;

         when 's' =>
            Gnatcheck.Diagnoses.Process_Report_File_Format_Parameter
              (Parameter, Success);

            if not Success then
               raise Parameter_Error;
            end if;

         when 'v' =>
            Verbose_Mode := True;

            Print_Version_Info;

         when others =>
            raise Parameter_Error;
      end case;
   end loop;

   loop
      Add_Source_To_Process
        (Get_Argument (Do_Expansion => True), No_More_Args);
      exit when No_More_Args;
   end loop;

   Process_Sections;

exception
   when GNAT.Command_Line.Invalid_Switch =>
      Error ("invalid switch : " & Full_Switch);
      Brief_Help;
      raise Parameter_Error;

   when GNAT.Command_Line.Invalid_Parameter =>
      Error ("parameter missed for : -" & Full_Switch);
      raise Parameter_Error;

end Scan_Parameters;
