------------------------------------------------------------------------------
--                                                                          --
--                           GNATSTUB COMPONENTS                            --
--                                                                          --
--     G N A T S T U B . S A M P L E R . P R E P A R E _ C O N T E X T      --
--                                                                          --
--                               B o d y                                    --
--                                                                          --
--         Copyright (c) 2003-2004, Free Software Foundation, Inc.          --
--                                                                          --
-- Gnatstub is free software; you can redistribute it and/or modify it      --
-- under terms of the  GNU General Public License  as published by the Free --
-- Software Foundation;  either version 2,  or  (at your option)  any later --
-- version. Gnatstub is distributed  in the hope  that it will be useful,   --
-- but WITHOUT ANY WARRANTY; without even the implied warranty of MER-      --
-- CHANTABILITY or  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General  --
-- Public License for more details. You should have received a copy of the  --
-- GNU General Public License distributed with GNAT; see file COPYING. If   --
-- not, write to the Free Software Foundation, 59 Temple Place Suite 330,   --
-- Boston, MA 02111-1307, USA.                                              --
--                                                                          --
-- Gnatstub is distributed as a part of the ASIS implementation for GNAT    --
-- (ASIS-for-GNAT).                                                         --
--                                                                          --
-- Gnatstub  was  originally  developed  by  Alexei Kuchumov  as a part of  --
-- collaboration  between  Software  Engineering  Laboratory of  the Swiss  --
-- Federal  Institute  of  Technology  in  Lausanne, Switzerland, and  the  --
-- Scientific  Research  Computer  Center  of the  Moscow State University, --
-- Russia.  This  work  was  supported  by  a grant from the Swiss National --
-- Science Foundation,  no 7SUPJ048247, funding a project  "Development of  --
-- ASIS for GNAT with industry quality".                                    --
--                                                                          --
-- Gnatstub  is  now  maintained  by  Ada  Core  Technologies  Inc          --
-- (http://www.gnat.com).                                                   --
------------------------------------------------------------------------------

--  This version of the body is for non-GNSA version

with ASIS_UL.Compiler_Options; use ASIS_UL.Compiler_Options;

separate (Gnatstub.Sampler)
procedure Prepare_Context is
   Success : Boolean := False;
begin
   if Tree_Exists and then Reuse_Tree then
      return;
   end if;

   Compile (File_Name, Arg_List.all, Success, GCC => Gcc_To_Call);

   if not Success then
      Put_Line (Standard_Error, "gnatstub: cannot create the tree file for "
               & File_Name.all);
      raise Parameter_Error;
   else
      Tree_Exists := True;
   end if;

   Asis.Implementation.Initialize;

   Associate
     (My_Context,
     "My_Context",
     "-C1 " & To_Wide_String (Tree_Name.all));

   Open (My_Context);

end Prepare_Context;
