------------------------------------------------------------------------------
--                                                                          --
--                           GNATELIM COMPONENTS                            --
--                                                                          --
--                             G N A T E L I M                              --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--            Copyright (C) 1998-2004 Ada Core Technologies, Inc.           --
--                                                                          --
-- GNATELIM  is  free software;  you can  redistribute it and/or  modify it --
-- under the terms of the  GNU  General Public License  as published by the --
-- Free Software Foundation; either version 2 or (at your option) any later --
-- version. GNATELIM is distributed in the hope that it will be useful, but --
-- WITHOUT ANY WARRANTY; without even the implied warranty of  MERCHANTABI- --
-- LITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public Li- --
-- cense for  more details.  You should  have  received  a copy of the  GNU --
-- General Public License distributed with GNAT; see file COPYING.  If not, --
-- write to  the  Free  Software  Foundation,  59 Temple Place - Suite 330, --
-- Boston, MA 02111-1307, USA.                                              --
--                                                                          --
-- The original version  of  Gnatelim  was developed by  Alain  Le  Guennec --
-- It is now maintained by Ada Core Technologies Inc  (http://www.gnat.com) --
--                                                                          --
------------------------------------------------------------------------------

--  This is a root package of gnatelim hierarchy. It contains the
--  definitions that are used throughout Gnatelim

with GNAT.OS_Lib; use GNAT.OS_Lib;

package Gnatelim is

   ------------------------------------
   -- Gnatelim configuration options --
   ------------------------------------

   Quiet_Mode : Boolean := False;
   --  If this flag is set OFF (the default), gnatelim generates in stderr
   --  names of the source files being processed. '-q' parameter sets the
   --  flag ON and this suppresses this file name trace.

   Verbose_Mode : Boolean := False;
   --  '-v' parameter
   --  In verbose mode gnatelim generates in stdout the version information in
   --  the form of Ada comments.

   Eliminate_In_RTL : Boolean := False;
   --  '-a' parameter
   --  When called without '-a' parameter, gnatelim generates Eliminate pragmas
   --  only for units which do not belong to the GNAT Run-Time Library (RTL).
   --  When called with '-a' parameter, gnatelim processes RTL components also
   --  and generates Eliminate pragmas for those of them for which the
   --  compiler does not generate implicit calls

   ----------------------------
   -- Gnatelim debug options --
   ----------------------------

   Progress_Indicator_Mode : Boolean := False;
   --  '-d' parameter
   --  Displays the progress indicator messages of the form
   --    'completed <unit number> out of <total number> (percentage)
   --  Intended for a GUI wrapper.

   Output_Debug_Information : Boolean := False;
   --  '-dv' parameter
   --  This option causes gnatelim to generate in stderr messages reflecting
   --  the main steps of the analysis being performed.

   Eliminate_Homonyms_By_Profile : Boolean := False;
   --  '-dh' parameter
   --  This option causes gnatelim to generate extended Eliminate pragmas for
   --  unused homonyms using parameter/result specification. When this
   --  option is disabled, homonyms are eliminated using their source location
   --  trace.

   -------------------------------------------
   -- String and source location data types --
   -------------------------------------------

   type String_Loc is record
      First, Last : Natural;
   end record;
   --  This record contains the start and end positions of a string inside
   --  a character table

   Empty_String : constant String_Loc := (0, 0);

   type Source_Loc is record
      Line, Col : Natural;
   end record;
   --  This record contains the SLOC of a syntactical element

   Empty_SLOC : constant Source_Loc := (0, 0);

   ------------------------
   -- Packed flags array --
   ------------------------

   type Flag_Array is array (1 .. 8) of Boolean;
   pragma Pack (Flag_Array);

   Empty_Flags : constant Flag_Array := (others => False);

   ---------------------------
   -- Type of unit analysis --
   ---------------------------

   type Analysis_Mode is (
      Normal,
      --  We try to analyze everything we can
      No_Instance_Bodies,
      --  This mode was used in the gnatelim generic processing model. The idea
      --  was to skip expanded bodies if the unit containing the corresponding
      --  instance is not the main unit in the tree and, therefore may not
      --  contain the structures needed to represent the expanded body. (We
      --  are speaking about the library-level instantiations here). But we
      --  have to get rid of this approach - when a unit is not the main unit
      --  in the currently processed tree, in some cases some expanded bodies
      --  can be processed, so if we skip ALL the expanded bodies, we may
      --  ourselves create a new source for generating the wrong pragmas.
      --
      --  We keep this mode to use it only for generating the debug information
      --  in -dv mode and for keeping the existing way of generating the unit
      --  trace in -v mode.
      Instance_Bodies_Only);
      --  We set this mode for the unit that has been already processed, but
      --  not as the main unit in the tree. For such a unit we have already
      --  collected all the information except some expanded bodies

   ---------------------------------
   -- Location of helper programs --
   ---------------------------------

   Gcc, Gnatmake : String_Access;

end Gnatelim;
