#ifndef protocolasdh
#define protocolasdh

#include <glib.h>

#include <protocol-asd-spec.h>

typedef struct
{
  int fd;
  guint32 id;
  gboolean auth;
} ProtocolAsdClient;

// Returnval: 0 -> continue in loop; 1 -> cancel loop/no-close; 2 -> cancel loop/close
typedef gint (*ProtocolAsdHandlerProc) (ProtocolAsdClient *client, ProtocolAsdRequest *request);

typedef struct 
{
  guint16 command;
  guint32 length;
  gboolean check_length;
  gboolean check_auth;
  ProtocolAsdHandlerProc proc;
  gchar *description;
} ProtocolAsdHandler;

gboolean protocol_asd_read_request(ProtocolAsdClient *client, ProtocolAsdRequest *request);
void protocol_asd_write_error(ProtocolAsdClient *client, ProtocolAsdRequest *request, guint16 error);
gboolean protocol_asd_write_ack(ProtocolAsdClient *client, ProtocolAsdRequest *request, guint32 l);
void protocol_asd_dispatch(int fd);
void protocol_asd_new_socket(int fd);

extern gboolean protocol_asd_auth_locked;

#endif
