#include "recursive-lock.h"

void recursive_lock(GStaticMutex *m, GStaticPrivate *p)
{
  guint *local;
  g_assert(m && p);

  if (!(local = g_static_private_get(p)))
    {
      local = g_new(guint, 1);
      *local = 0;
      g_static_private_set(p, local, g_free);
    }

  if (*local == 0)
    g_static_mutex_lock(m);

  (*local)++;
}

void recursive_unlock(GStaticMutex *m, GStaticPrivate *p)
{
  guint *local;

  g_assert(m && p);

  g_assert(local = g_static_private_get(p));
  g_assert(*local > 0);

  (*local)--;

  if (*local == 0)
    g_static_mutex_unlock(m);
}
