/*

*************************************************************************

ArmageTron -- Just another Tron Lightcycle Game in 3D.
Copyright (C) 2000  Manuel Moos (manuel@moosnet.de)

**************************************************************************

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  
***************************************************************************

*/

#ifndef ArmageTron_consoleBase_H
#define ArmageTron_consoleBase_H

#include "tString.h"
#include "defs.h"

class tConsole{
 public:
  virtual ~tConsole();

  virtual tConsole & Print(const tString &s);

  template<class T> tConsole & operator<<(const T&x){
    tString s;
    s << x;
    return Print(s);
  }

  virtual void CenterDisplay(const tString &s,REAL timeout=2,REAL r=1,REAL g=1,REAL b=1);

  virtual tString ColorString(REAL r, REAL g, REAL b) const;
 protected:
  static void RegisterBetterConsole(tConsole *better);
 
 private:
  static tConsole *s_betterConsole;
};

extern tConsole con;


#endif
