/*

*************************************************************************

ArmageTron -- Just another Tron Lightcycle Game in 3D.
Copyright (C) 2000  Manuel Moos (manuel@moosnet.de)

**************************************************************************

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  
***************************************************************************

*/

#include "tConsole.h"
#include <iostream.h>

tConsole *tConsole::s_betterConsole=NULL;

tConsole::~tConsole(){
  if (s_betterConsole == this)
    s_betterConsole = NULL;
};

tConsole & tConsole::Print(const tString &s){
  if (s_betterConsole)
    return s_betterConsole->Print(s);
  else{
    cout << s;
    return *this;
  }
}

void tConsole::CenterDisplay(const tString &s,REAL timeout,REAL r,REAL g,REAL b){
  if (s_betterConsole)
    s_betterConsole->CenterDisplay(s,timeout,r,g,b);
  else{
    cout << s;
  }
}

void tConsole::RegisterBetterConsole(tConsole *better){
  s_betterConsole = better;
}

tString tConsole::ColorString(REAL r, REAL g, REAL b) const{
  if (s_betterConsole)
    return s_betterConsole->ColorString(r,g,b);
  else
    return "";
}

 
tConsole con;
