// vs_minibuf_win.cc
//
//  Copyright 2000 Daniel Burrows
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; see the file COPYING.  If not, write to
//  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//  Boston, MA 02111-1307, USA.

#include "vs_minibuf_win.h"
#include "vs_label.h"
#include "vs_multiplex.h"

#include <sigc++/bind.h>

using namespace std;

vs_minibuf_win::vs_minibuf_win()
  :vs_passthrough(), main_widget(NULL)
{
  do_layout.connect(slot(this, &vs_minibuf_win::layout_me));

  status=new vs_multiplex;
  status_lbl=new vs_label("", get_color("ScreenStatusColor"));
  status->add_widget(status_lbl);
  header=new vs_label("", get_color("ScreenHeaderColor"));

  status->set_owner(this);
  header->set_owner(this);
  status_lbl->show();
  status->show();
  header->show();
}

vs_minibuf_win::~vs_minibuf_win()
{
  set_main_widget(NULL);

  delete header;
  delete status;
}

void vs_minibuf_win::set_main_widget(vscreen_widget *w)
{
  defocus();

  if(main_widget)
    {
      main_destroy_conn.disconnect();
      main_widget->set_owner(NULL);
    }

  main_widget=w;

  if(main_widget)
    {
      main_widget->set_owner(this);
      main_destroy_conn=main_widget->destroyed.connect(bind(slot(this, &vs_minibuf_win::set_main_widget), (vscreen_widget *) NULL));
    }
  refocus();

  vscreen_queuelayout();
  vscreen_update();
}

size vs_minibuf_win::size_request()
{
  int w=0, h=2;

  size req=status->size_request();
  if(w<req.w)
    w=req.w;

  req=header->size_request();
  if(w<req.w)
    w=req.w;

  if(main_widget)
    {
      req=main_widget->size_request();
      if(w<req.w)
	w=req.w;
      if(h-2<req.h)
	h=req.h+2;
    }

  return size(w, h);
}

void vs_minibuf_win::layout_me()
{
  header->alloc_size(0, 0, getmaxx(), 1);

  if(getmaxy()>1)
    {
      if(getmaxy()>2 && main_widget)
	main_widget->alloc_size(0, 1, getmaxx(), getmaxy()-2);

      status->alloc_size(0, getmaxy()-1, getmaxx(), 1);
    }
}

void vs_minibuf_win::paint()
{
  if(main_widget && main_widget->get_visible())
    main_widget->display();

  status->display();
  header->display();
}

void vs_minibuf_win::set_header(string new_header)
{
  header->set_text(new_header);
}

void vs_minibuf_win::set_status(string new_status)
{
  status_lbl->set_text(new_status);
}

void vs_minibuf_win::add_widget(vscreen_widget *widget)
{
  defocus();
  status->add_widget(widget);
  refocus();
}

void vs_minibuf_win::rem_widget(vscreen_widget *widget)
{
  defocus();
  status->rem_widget(widget);
  refocus();
}

void vs_minibuf_win::show_all()
{
  if(main_widget)
    main_widget->show_all();
  status->show();
  header->show();
}

vscreen_widget *vs_minibuf_win::get_focus()
{
  if(status->focus_me())
    return status;
  else if(main_widget && main_widget->get_visible() && main_widget->focus_me())
    return main_widget;
  else
    return NULL;
}

void vs_minibuf_win::display_error(string err)
{
  add_widget(new vs_transientlabel(err, get_color("Error")|A_BOLD));
}
