/* Copyright (C) 2006 Jan Wedekind.
   This file is part of the recipe database application AnyMeal.

   AnyMeal is free software; you can redistribute it and/or modify it under
   the terms of the GNU GENERAL PUBLIC LICENSE as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   AnyMeal is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTIBILITY or FITNESS
   FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
   details.

   You should have received a copy of the GNU General Public License along
   with AnyMeal; if not, contact one of the authors of this software. */
#include <boost/shared_array.hpp>
#include "recoder.hpp"

using namespace boost;
using namespace std;

const char *program_name = PACKAGE;

RECODE_OUTER Recoder::outer = NULL;

Recoder::Recoder( const std::string &_request ) throw (Error):
  request(NULL)
{
  assert( outer != NULL );
  request = recode_new_request( outer );
  ERRORMACRO( request, Error, , "Error allocating recoding request." );
#ifndef NDEBUG
  request->verbose_flag = true;
#endif
  request->ascii_graphics = true;
  if ( !recode_scan_request( request, _request.c_str() ) ) {
    recode_delete_request( request );
    ERRORMACRO( false, Error, ,
                "Error requesting " << _request << " recoder." );
  };
}

Recoder::~Recoder(void)
{
  recode_delete_request (request);
}

void Recoder::translate( std::istream &inputStream,
                         std::ostream &outputStream ) const
  throw (Error)
{
  streampos pos = inputStream.tellg();
  inputStream.seekg( 0, ios::end );
  int filesize = inputStream.tellg() - pos;
  inputStream.seekg( pos, ios::beg );
  
  shared_array< char > inputData( new char[filesize] );
  inputStream.read( inputData.get(), filesize );
  
  char *outputData = NULL;
  size_t
    outputLength = 0,
    outputAllocated = 0;

  bool retVal =
    recode_buffer_to_buffer( request, inputData.get(), filesize,
                             &outputData, &outputLength, &outputAllocated );

  inputData.reset();

  ERRORMACRO( retVal, Error, , "Error while recoding stream." );
  outputStream.write( outputData, outputLength );

  if ( outputData != NULL )
    free( outputData );
}
