/* Copyright (C) 2002, 2003, 2004, 2005 Jan Wedekind.
   This file is part of the recipe database application AnyMeal.

   AnyMeal is free software; you can redistribute it and/or modify it under
   the terms of the GNU GENERAL PUBLIC LICENSE as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   AnyMeal is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTIBILITY or FITNESS
   FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
   details.

   You should have received a copy of the GNU General Public License along
   with AnyMeal; if not, contact one of the authors of this software. */
/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename slots use Qt Designer which will
** update this file, preserving your code. Create an init() slot in place of
** a constructor, and a destroy() slot in place of a destructor.
*****************************************************************************/


void RecipeListDisplay::init()
{
  clickedItem = NULL;
  menu = new QPopupMenu( recipeList );
  displayId = menu->insertItem( QPixmap::fromMimeSource( "anymeal.png" ),
                                i18n( "Dis&play" ), this,
                                SLOT( displayCurrentRecipe() ) );
  editId = menu->insertItem( QPixmap::fromMimeSource( "editnew.png" ),
                             i18n( "&Edit" ), this,
                             SLOT( editCurrentRecipe() ) );
  menu->insertSeparator();
  menu->insertItem( QPixmap::fromMimeSource( "checked.png" ),
                    i18n( "&Select" ), this, SLOT( selectCurrentRecipes() ) );
  menu->insertItem( QPixmap::fromMimeSource( "unchecked.png" ),
                    i18n( "Desele&ct" ), this,
                    SLOT( deselectCurrentRecipes() ) );
  QPopupMenu *exporting = new QPopupMenu( recipeList );
  exporting->insertItem( QPixmap::fromMimeSource( "exportMM.png" ),
                         i18n( "&MealMaster" ), this,
                         SLOT( exportMealMasterCurrentRecipes() ) );
  exporting->insertItem( QPixmap::fromMimeSource( "exportRecipeML.png" ),
                         i18n( "&RecipeML" ), this,
                         SLOT( exportRecipeMLCurrentRecipes() ) );
  exporting->insertSeparator();
  exporting->insertItem( QPixmap::fromMimeSource( "exportDocbook.png" ),
                         i18n( "Doc&book" ), this,
                         SLOT( exportDocbookCurrentRecipes() ) );
  exporting->insertItem( QPixmap::fromMimeSource( "exportFO.png" ),
                         i18n( "&FO" ), this,
                         SLOT( exportFOCurrentRecipes() ) );
  exporting->insertItem( QPixmap::fromMimeSource( "exportHTML.png" ),
                         i18n( "&HTML" ), this,
                         SLOT( exportHTMLCurrentRecipes() ) );
  menu->insertItem( QPixmap::fromMimeSource( "export.png" ),
                    i18n( "E&xport" ), exporting );
  menu->insertSeparator();
  menu->insertItem( QPixmap::fromMimeSource( "deleteRecipe.png" ),
                    i18n( "&Delete" ), this, SLOT( deleteCurrentRecipes() ) );

  recipeList->setColumnAlignment( 0, Qt::AlignRight );
}


void RecipeListDisplay::selectRecipes( const std::string &selection, bool state )
{
  XMLDocument xmlDocument( "" );
  xmlDocument.fromString( std::string( "\n" ) + selection );
  XMLNodeReferenceList nodeList =
    xmlDocument.getDocumentElement().selectNodes( "/single|/list/id" );
  for ( int i=0; i<nodeList.getLength(); i++ ) {
    RecipeListItem *recipeListItem =
      (RecipeListItem *)recipeList->
      findItem( nodeList.item( i ).getNodeText(), 0 );
    if ( recipeListItem != NULL ) recipeListItem->setOn( state );
  };
}

void RecipeListDisplay::recipeItemClicked( QListViewItem *item )
{
  if ( item ) {
    RecipeListItem *recipeListItem = (RecipeListItem *)item;
    std::ostringstream selection;
    selection << "<single>" << recipeListItem->getId() << "</single>";
    bool newState = recipeListItem->isOn();
    emit recipesSelected( selection.str(), newState );
  };
}


void RecipeListDisplay::recipeItemDoubleClicked( QListViewItem *item )
{
  if ( item ) {
    RecipeListItem *recipeListItem = (RecipeListItem *)item;
    int id = recipeListItem->getId();
    emit displayRecipe( id );
  };
}

void RecipeListDisplay::recipeIdDeleted( int id )
{
  RecipeListItem *recipeListItem = (RecipeListItem *)recipeList->firstChild();
  while ( recipeListItem != NULL ) {
    if ( recipeListItem->getId() == id ) {
      delete recipeListItem;
      break;
    };
    recipeListItem = (RecipeListItem *)recipeListItem->nextSibling();
  };
}

void RecipeListDisplay::recipeIdChanged( int id, int newId,
                                         const QString &newTitle,
                                         const QString & )
{
  RecipeListItem *recipeListItem = (RecipeListItem *)recipeList->firstChild();
  while ( recipeListItem != NULL ) {
    if ( recipeListItem->getId() == id ) {
      recipeListItem->setId( newId );
      recipeListItem->setTitle( newTitle );
      break;
    };
    recipeListItem = (RecipeListItem *)recipeListItem->nextSibling();
  };
}

void RecipeListDisplay::openContextMenu( QListViewItem *item,
                                         const QPoint &point, int )
{
  if ( item != NULL ) {
    clickedItem = (RecipeListItem *)item;
    // Editing and displaying only supported for single recipe.
    bool isSingle = getNumSelected() == 1;
    menu->setItemEnabled( displayId, isSingle );
    menu->setItemEnabled( editId, isSingle );
    menu->popup( point );
  };
}

void RecipeListDisplay::displayCurrentRecipe(void)
{
  assert( clickedItem != NULL );
  emit displayRecipe( clickedItem->getId() );
  clickedItem = NULL;
}

void RecipeListDisplay::editCurrentRecipe(void)
{
  assert( clickedItem != NULL );
  emit editRecipe( clickedItem->getId() );
  clickedItem = NULL;
}

void RecipeListDisplay::selectCurrentRecipes(void)
{
  std::string selection( getSelection() );
  selectRecipes( selection, true );
  emit recipesSelected( selection, true );
}

void RecipeListDisplay::deselectCurrentRecipes(void)
{
  std::string selection( getSelection() );
  selectRecipes( selection, false );
  emit recipesSelected( selection, false );
}

void RecipeListDisplay::deleteCurrentRecipes(void)
{
  emit deleteRecipes( getSelection() );
}

void RecipeListDisplay::exportMealMasterCurrentRecipes(void)
{
  emit exportMealMasterRecipes( getSelection() );
}

void RecipeListDisplay::exportDocbookCurrentRecipes(void)
{
  emit exportDocbookRecipes( getSelection() );
}

void RecipeListDisplay::exportFOCurrentRecipes(void)
{
  emit exportFORecipes( getSelection() );
}

void RecipeListDisplay::exportHTMLCurrentRecipes(void)
{
  emit exportHTMLRecipes( getSelection() );
}

void RecipeListDisplay::exportRecipeMLCurrentRecipes(void)
{
  emit exportRecipeMLRecipes( getSelection() );
}

std::string RecipeListDisplay::getSelection(void)
{
  std::ostringstream selection; selection << "<list>" << std::endl;
  RecipeListItem *recipeListItem = (RecipeListItem *)recipeList->firstChild();
  while ( recipeListItem != NULL ) {
    if ( recipeListItem->isSelected() )
      selection << "<id>" << recipeListItem->getId() << "</id>" << std::endl;
    recipeListItem = (RecipeListItem *)recipeListItem->nextSibling();
  };
  selection << "</list>" << std::endl;
  return selection.str();
}

int RecipeListDisplay::getNumSelected(void)
{
  int retVal = 0;
  RecipeListItem *recipeListItem = (RecipeListItem *)recipeList->firstChild();
  while ( recipeListItem != NULL ) {
    if ( recipeListItem->isSelected() ) retVal++;
    recipeListItem = (RecipeListItem *)recipeListItem->nextSibling();
  };
  return retVal;
}
