<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version="1.0">

  <xsl:output method="xml" indent="yes" version="1.0" encoding="UTF-8"/>

  <xsl:template match="/insert|/sqlout">
    <recipeml version="0.5" generator="anymeal">
      <menu system="metric">
        <head>
          <title>Cookbook</title>
        </head>
        <xsl:apply-templates select="recipe"/>
      </menu>
    </recipeml>
  </xsl:template>

  <xsl:template match="recipe">
    <recipe>
      <head>
        <title><xsl:value-of select="title"/></title>
        <categories>
          <xsl:for-each select="categories/category">
            <cat><xsl:value-of select="."/></cat>
          </xsl:for-each>
        </categories>
        <yield>
          <qty><xsl:value-of select="servings/amount"/></qty>
          <unit><xsl:value-of select="servings/unit"/></unit>
        </yield>
      </head>
      <ingredients>
        <xsl:for-each select="ingredients/section">
          <ing-div>
            <xsl:if test="title">
              <title><xsl:value-of select="title"/></title>
            </xsl:if>
            <xsl:for-each select="ingredient">
              <ing>
                <amt>
                  <xsl:if test="amount">
                    <qty>
                      <xsl:choose>
                        <xsl:when test="amount/float">
                          <xsl:value-of select="amount/float"/>
                        </xsl:when>
                        <xsl:otherwise>
                          <xsl:choose>
                            <xsl:when test="amount/fraction/nominator >= amount/fraction/denominator">
                              <xsl:value-of select="floor(amount/fraction/nominator div amount/fraction/denominator)"/>
                              <xsl:if test="amount/fraction/nominator mod amount/fraction/denominator > 0">
                                <xsl:text> </xsl:text>
                                <xsl:value-of select="amount/fraction/nominator mod amount/fraction/denominator"/>
                                <xsl:text>/</xsl:text>
                                <xsl:value-of select="amount/fraction/denominator"/>
                              </xsl:if>
                            </xsl:when>
                            <xsl:otherwise>
                              <xsl:value-of select="amount/fraction/nominator"/>
                              <xsl:text>/</xsl:text>
                              <xsl:value-of select="amount/fraction/denominator"/>
                            </xsl:otherwise>
                          </xsl:choose>
                        </xsl:otherwise>
                      </xsl:choose>
                    </qty>
                  </xsl:if>
                  <xsl:if test="unit">
                    <unit><xsl:value-of select="unit"/></unit>
                  </xsl:if>
                </amt>
                <item><xsl:value-of select="name"/></item>
                <xsl:if test="prep">
                  <prep><xsl:value-of select="prep"/></prep>
                </xsl:if>
              </ing>
            </xsl:for-each>
          </ing-div>
        </xsl:for-each>
      </ingredients>
      <directions>
        <xsl:for-each select="instructions/section">
          <step>
            <xsl:if test="title">
              <xsl:attribute name="title">
                <xsl:value-of select="title"/>
              </xsl:attribute>
            </xsl:if>
            <xsl:for-each select="par">
              <xsl:call-template name="printParagraph">
                <xsl:with-param name="text" select="."/>
              </xsl:call-template>
              <xsl:if test="not(position()=last())">
                <xsl:text>&#xA;</xsl:text>
              </xsl:if>
              <xsl:text>&#xA;</xsl:text>
            </xsl:for-each>
          </step>
        </xsl:for-each>
      </directions>
    </recipe>
  </xsl:template>

  <xsl:template name="printParagraph">
    <xsl:param name="text"/>
    <xsl:param name="avail">74</xsl:param>
    <xsl:choose>
      <xsl:when test="contains($text,' ')">
        <xsl:choose>
          <xsl:when test="string-length(substring-before($text,' '))>$avail">
            <xsl:text>&#xA;</xsl:text>
            <xsl:value-of select="substring-before($text,' ')"/>
            <xsl:call-template name="printParagraph">
              <xsl:with-param name="text" select="substring-after($text,' ')"/>
              <xsl:with-param name="avail" select="74 - string-length(substring-before($text,' '))"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:otherwise>
            <xsl:if test="$avail &lt; 74">
              <xsl:text> </xsl:text>
            </xsl:if>
            <xsl:value-of select="substring-before($text,' ')"/>
            <xsl:call-template name="printParagraph">
              <xsl:with-param name="text" select="substring-after($text,' ')"/>
              <xsl:with-param name="avail" select="$avail - 1 - string-length(substring-before($text,' '))"/>
            </xsl:call-template>
          </xsl:otherwise>
        </xsl:choose>  
      </xsl:when>
      <xsl:otherwise>
        <xsl:if test="$avail &lt; 74">
          <xsl:text> </xsl:text>
        </xsl:if>
        <xsl:value-of select="$text"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

</xsl:stylesheet>
