#ifndef CONNECTION_H__
#define CONNECTION_H__

#define	RAW	0	// These two are in place for send_to_socket
#define	COOKED	1

#include "sysdep.h"
#include "strings.h"
#include "mudtypes.h"

#include "ClientSocket.h"

class MudObject;
class Connection;


struct snoop_struct {
   Connection   *user;
   snoop_struct *next_snoop;
};


#define SNOOP_SPECTATE 0

class Connection {
public:
	void unlock();
	BOOL set_locked();
	void set_valid();

	CClientSocket * get_socket();

	void set_invalid();

	int accept_conn(MudObject *the_user);

   int     check_socket();
   int     send_to_socket(char *the_string, int cook_mode);
   int     send_to_socket(char *the_string);
   int     send_to_socket(Strings *the_string, int cook_mode);
   int     send_to_socket(Strings *the_string);
   time_t     lost_link();
   bool       has_input();
   bool       has_output(); 
   Strings    *get_input();
   void       flush();

   int        find_host_addr();
   char       *get_ip_addr();
   char       *get_host_addr();
   int        echo_off();
   int        echo_on();
   int        get_socknum();
   void       set_color(int the_val);
   time_t     get_idle(void);

   Strings    *get_pager_buffer();
   void       start_paging();
   int        end_paging(MudObject *the_user);

   int	      set_owner(MudObject *sock_own);

   int        add_snoop(Connection *the_conn);
   int        remove_snoop(Connection *the_conn);
   int        has_snoop(Connection *the_conn);
   int        remove_all_snoop(int snoop_type);
   int        send_to_snoopers(char *the_output);
   int        send_to_snoopers(char *the_output, int is_input);

   Connection();
   ~Connection();

private:

   int write_to_buffer(char *the_string);


   CClientSocket list_sock;

   struct sockaddr_in sin;

   bool 		valid_socket;

   bool         hold_buffers;

   Strings      pager_buffer;

   Strings      ip_addr;
   Strings      host_addr;

   int          use_color;

   MudObject	*owner;		// Player/Builder this connection is attached to

   snoop_struct *snoop_list;   /* who is listening in to our output */

   time_t       lost_connection;     /* when this person lost link */
   time_t       last_input;          /* when the last full input was */
};

#endif
