// ---------------------------------------------------------------------------
// - Utility.hpp                                                             -
// - standard object library - utility functions definition                  -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2007 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef  AFNIX_UTILITY_HPP
#define  AFNIX_UTILITY_HPP

#ifndef  AFNIX_STRING_HPP
#include "String.hpp"
#endif

namespace afnix {

  /// The utility class is a collection of static convenient functions. There
  /// purposes is to group general purpose functions into a single umbrella.
  /// @author amaury darsch

  class Utility {
  public:
    /// @return the maximum integer value (positive)
    static long maxlong (void);

    /// @return the minimum integer value (negative)
    static long minlong (void);

    /// @return the closest prime number to the value
    static long toprime (const long value);    
    
    /// convert a string to an integer
    /// @param value the string to convert
    static t_long tointeger (const String& value);

    /// convert an integer to a string
    /// @param value the integer to convert
    static String tostring (const long value);

    /// convert an integer to a string
    /// @param value the integer to convert
    static String tostring (const t_long value);

    /// convert an integer to a hexadecimal string
    /// @param value the integer to convert
    static String tohexa (const long value);

    /// convert an integer to a hexadecimal string
    /// @param value the integer to convert
    static String tohexa (const t_long value);

    /// @return a long random number
    static long longrnd (void);

    /// @return a long random number
    static long longrnd (const long max);

    /// @return a real random number
    static t_real realrnd (void);

    /// @return a byte random number
    static t_byte byternd (void);

    /// @return a control character by printable character
    static t_quad toctrl (const char value);
  };
}

#endif
