// ---------------------------------------------------------------------------
// - cgen.hpp                                                                -
// - standard system library - C generator functions definition              -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2007 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef  AFNIX_CGEN_HPP
#define  AFNIX_CGEN_HPP

#ifndef  AFNIX_CCNF_HPP
#include "ccnf.hpp"
#endif

namespace afnix {

  /// @return a long random number
  long   c_longrnd (void);

  /// @return a long random number
  long   c_longrnd (const long max);

  /// @return a real random number between 0.0 and 1.0
  t_real c_realrnd (void);

  /// @return a random byte
  t_byte c_byternd (void);
}

#endif
