<?php
/*  
 * Analysis Console for Incident Databases (ACID)
 *
 * Author: Roman Danyliw <rdd@cert.org>, <roman@danyliw.com>
 *
 * Copyright (C) 2000, 2001 Carnegie Mellon University
 * (see the file 'acid_main.php' for license details)
 *
 * Purpose:   
 *
 * Input GET/POST variables
 *   - caller: specifies the canned snapshot to run
 *   - submit:
 */

/*
 * $caller: an auxiliary variable used to determine the how the search parameters were entered (i.e.
 *          whether through a form or through another mechanism
 *  - "stat_alerts" : display results based on the the Alert Listings
 *  - "top_tcp" :
 *  - "top_udp" :
 *  - "top_icmp" :
 *  - "last_tcp" :
 *  - "last_udp" :
 *  - "last_icmp" :
 *
 * $submit: used to determine the next action which should be taken when the form is submitted.
 *  - "Query DB"       : triggers a query into the database
 *  - "ADD Time"       : adds another date/time row 
 *  - "ADD Addr"       : adds another IP address row
 *  - "ADD IP Field"   : adds another IP field row
 *  - "ADD TCP Port"   : adds another TCP port row
 *  - "ADD TCP Field"  : adds another TCP field row
 *  - "ADD UDP Port"   : adds another UDP port row
 *  - "ADD UDP Field"  : adds another UDP field row
 *  - "ADD ICMP Field" : adds another ICMP field row
 *  - "#X-(X-X)"       : sid-cid keys for a packet lookup
 *
 * $layer4: stores the layer 4 protocol used in query
 *
 * $save_sql: the current sql string generating the query
 *
 * $save_criteria: HTML-human readable criteria of the $save_sql string
 *
 * $num_result_rows: rows in the entire record set retried under the current 
 *                   query
 *
 * $current_view: current view of the result set
 *
 * $sort_order: how to sort the output
 *
 * Meta
 * ====
 * 
 * $ag: AG ID 
 *
 * $sensor: sensor ID
 *
 * $sig[3]: stores signature
 *   - [0] : exactly, roughly             [1] : signature
 *   - [2] : =, !=
 *
 * $sig_class: signature classification
 *
 * $time[MAX][10]: stores the date/time of the packet detection
 *  - [][0] : (                           [][5] : hour  
 *  - [][1] : =, !=, <, <=, >, >=         [][6] : minute
 *  - [][2] : month                       [][7] : second
 *  - [][3] : day                         [][8] : (, )
 *  - [][4] : year                        [][9] : AND, OR
 *
 * $time_cnt : number of rows in the $time[][] structure
 *
 * IP Variables
 * ============
 *
 * $ip_addr[MAX][10]: stores an ip address parameters/operators row
 *  - [][0] : (                          [][5] : octet3 of address
 *  - [][1] : source, dest               [][6] : octet4 of address
 *  - [][2] : =, !=                      [][7] : network mask
 *  - [][3] : octet1 of address          [][8] : (, )
 *  - [][4] : octet2 of address          [][9] : AND, OR
 *
 * $ip_addr_cnt: number of rows in the $ip_addr[][] structure
 *
 * $ip_field[MAX][6]: stores all other ip fields parameters/operators row
 *  - [][0] : (                            [][3] : field value
 *  - [][1] : TOS, TTL, ID, offset, length [][4] : (, )
 *  - [][2] : =, !=, <, <=, >, >=          [][5] : AND, OR
 *
 * $ip_field_cnt: number of rows in the $ip_field[][] structure
 *
 * TCP Variables
 * =============
 *
 * $tcp_port[MAX][6]: stores all port parameters/operators row
 *  - [][0] : (                            [][3] : port value
 *  - [][1] : Source Port, Dest Port       [][4] : (, )
 *  - [][2] : =, !=, <, <=, >, >=          [][5] : AND, OR
 *
 * $tcp_port_cnt: number of rows in the $tcp_port[][] structure
 *
 * $tcp_flags[7]: stores all other tcp flags parameters/operators row
 *  - [0] : is, contains                   [4] : 8     (RST)
 *  - [1] : 1   (FIN)                      [5] : 16    (ACK)
 *  - [2] : 2   (SYN)                      [6] : 32    (URG)
 *  - [3] : 4   (PUSH)
 *
 * $tcp_field[MAX][6]: stores all other tcp fields parameters/operators row
 *  - [][0] : (                            [][3] : field value
 *  - [][1] : windows, URP                 [][4] : (, )
 *  - [][2] : =, !=, <, <=, >, >=          [][5] : AND, OR
 *
 * $tcp_field_cnt: number of rows in the $tcp_field[][] structure
 *
 * UDP Variables
 * =============
 *
 * $udp_port[MAX][6]: stores all port parameters/operators row
 *  - [][0] : (                            [][3] : port value
 *  - [][1] : Source Port, Dest Port       [][4] : (, )
 *  - [][2] : =, !=, <, <=, >, >=          [][5] : AND, OR
 *
 * $udp_port_cnt: number of rows in the $udp_port[][] structure
 *
 * $udp_field[MAX][6]: stores all other udp fields parameters/operators row
 *  - [][0] : (                            [][3] : field value
 *  - [][1] : length                       [][4] : (, )
 *  - [][2] : =, !=, <, <=, >, >=          [][5] : AND, OR
 *
 * $udp_field_cnt: number of rows in the $udp_field[][] structure
 *
 * ICMP Variables
 * ==============
 * $icmp_field[MAX][6]: stores all other icmp fields parameters/operators row
 *  - [][0] : (                            [][3] : field value
 *  - [][1] : code, length                 [][4] : (, )
 *  - [][2] : =, !=, <, <=, >, >=          [][5] : AND, OR
 *
 * $icmp_field_cnt: number of rows in the $icmp_field[][] structure
 *
 * Payload Variables
 * =================
 * $data_encode[2]: how the payload should be interpreted and converted
 *  - [0] : encoding type (hex, ascii)
 *  - [1] : conversion type (hex, ascii) 
 *
 * $data[MAX][5]: stores all the payload related parameters/operators row
 *  - [][0] : (                            [][3] : (, )
 *  - [][1] : =, !=                        [][4] : AND, OR
 *  - [][2] : field value
 *
 * $data_cnt: number of rows in the $data[][] structure
 *
 * ----- Search Result Variables ----
 * $action_chk_lst[]: array of check boxes to determine if an alert
 *                    was selected for action
 * $action_lst[]: array of (sid,cid) of all alerts on screen
 */
?>
<?php
  include("acid_constants.inc");
  include("acid_conf.php");
  include("acid_include.inc");

  include_once("acid_action.inc");
  include_once("acid_db_common.php");
  include_once("acid_common.php");
  include_once("acid_ag_common.php");
  include_once("acid_qry_common.php");

  $et = new EventTiming($debug_time_mode);
  $cs = new CriteriaState("acid_qry_main.php", "&new=1&submit=Query+DB");

  $new = ImportHTTPVar("new");
  $submit = ImportHTTPVar("submit");
  $layer4 = ImportHTTPVar("layer4");

/* Code to correct 'interesting' (read: unexplained) browser behavior
 */

/* Something with Netscape 4.75 such that the $submit variable is no recognized
 * under certain circumstances.  This one is a result of using HTTPS and 
 * clicking on TCP traffic profile from acid_main.php 
 */
if ( $layer4 != "" && $submit == "" )
   $submit = "Query DB";

/* End 'interesting' browser code fixes */

  /* Totally new Search */
  if ( ($new == 1) && ($submit == "") ) 
  {
     /* Read the state to import the history */
     $cs->ReadState();
   
     /* 
      * Save the variables associated with keeping history,
      * or they will be deleted in the InitState() call
      */
     $save_back_list = $GLOBALS['back_list'];
     $save_back_list_cnt = $GLOBALS['back_list_cnt'];
 
     $cs->InitState();

     /* Restore the history variables */
     $back_list = $save_back_list;
     $back_list_cnt = $save_back_list_cnt;

     $time_cnt = 1;
     $ip_addr_cnt = 1;
     $ip_field_cnt = 1;
     $tcp_port_cnt = 1;
     $tcp_field_cnt = 1;
     $udp_port_cnt = 1;
     $udp_field_cnt = 1;
     $icmp_field_cnt = 1;
     $data_cnt = 1;
     $layer4 = "";
  }

  /* if scrolling between pages read the session */
  /* if access the first query result page from the criteria specification
   *   then read the session and migrate the POST variables into the session
   */ 
  else
  {
     $cs->ReadState();
  }

  $qs = new QueryState();
  $qs->AddCannedQuery("last_tcp", $last_num_alerts, "Last TCP", "time_d"); 
  $qs->AddCannedQuery("last_udp", $last_num_alerts, "Last UDP Alerts", "time_d");
  $qs->AddCannedQuery("last_icmp", $last_num_alerts, "Last ICMP Alerts", "time_d");
  $qs->AddCannedQuery("last_any", $last_num_alerts, "Last Alerts", "time_d");

  $page_title = "Query Results";
  if ( $qs->isCannedQuery() )
     PrintACIDSubHeader($page_title.": ".$qs->GetCurrentCannedQueryDesc(),
                        $page_title.": ".$qs->GetCurrentCannedQueryDesc(), $cs->GetBackLink());
  else
     PrintACIDSubHeader($page_title, $page_title, $cs->GetBackLink());

  if ( in_array( $qs->GetCurrentCannedQuery(),
                 array ("last_tcp", "last_udp", "last_icmp", "last_any") ) )
       PrintFreshPage($refresh_stat_page, $stat_page_refresh_time);

  /* Connect to the Alert database */
  $db = NewACIDDBConnection($DBlib_path, $DBtype);
  $db->acidDBConnect($db_connect_method,
                     $alert_dbname, $alert_host, $alert_port, $alert_user, $alert_password);

  if ( $event_cache_auto_update == 1 )  UpdateAlertCache($db);

  $printing_ag = false;
?>

<FORM METHOD="POST" NAME="PacketForm" ACTION="acid_qry_main.php">

<?php
/* Dump some debugging information on the shared state */
if ( $debug_mode > 0 )
{
   PrintCriteriaState();
}

/* a browsing button was clicked -> increment view */
if ( is_numeric($submit) )
{
    if ( $debug_mode > 0 ) ErrorMessage("Browsing Clicked ($submit)");
    $qs->MoveView($submit);
    $submit = "Query DB";
}

/* Run the SQL Query and get results */
if ( $submit == "Query DB" ||
     $submit == "Selected" || $submit == "ALL on Screen" || $submit == "Entire Query" || 
     $qs->isCannedQuery() || 
     $sort_order != "" )
{
  /* Init and run the action */
  $criteria_clauses = ProcessCriteria();  

  $from = " FROM acid_event ".$criteria_clauses[0];
  $where = " WHERE ".$criteria_clauses[1];

  $qs->AddValidAction("ag_by_id");
  $qs->AddValidAction("ag_by_name");
  $qs->AddValidAction("del_alert");
  $qs->AddValidAction("email_alert");
  $qs->AddValidAction("email_alert2");
  $qs->AddValidAction("archive_alert");
  $qs->AddValidAction("archive_alert2");

  $qs->AddValidActionOp("Selected");
  $qs->AddValidActionOp("ALL on Screen");
  $qs->AddValidActionOp("Entire Query");

  $qs->SetActionSQL("SELECT acid_event.sid, acid_event.cid $from $where");
  $et->Mark("Initialization");

  $qs->RunAction($submit, PAGE_QRY_ALERTS, $db);
  $et->Mark("Alert Action");

  if ( $debug_mode > 0 ) ErrorMessage("Initial/Canned Query or Sort Clicked");
  include("acid_qry_sqlcalls.php");
}
/* Return the input form to get more criteria from user */
else
{
   include("acid_qry_form.php");
}

/* Stores the neccessary variables for shared state between calls */

/* These variables will ultimately be stored in the session, but are 
 * temporarily required while criteria is being entered in the form
 */
//if ( ($HTTP_POST_VARS["new"] == 1) || ($HTTP_GET_VARS["new"] == 1) )
if ( $new == 1 )
{ 
   echo '<INPUT TYPE="hidden" NAME="time_cnt" VALUE="'.$time_cnt.'">';
   echo '<INPUT TYPE="hidden" NAME="ip_addr_cnt" VALUE="'.$ip_addr_cnt.'">';
   echo '<INPUT TYPE="hidden" NAME="ip_field_cnt" VALUE="'.$ip_field_cnt.'">';
   echo '<INPUT TYPE="hidden" NAME="tcp_port_cnt" VALUE="'.$tcp_port_cnt.'">';
   echo '<INPUT TYPE="hidden" NAME="tcp_field_cnt" VALUE="'.$tcp_field_cnt.'">';
   echo '<INPUT TYPE="hidden" NAME="udp_port_cnt" VALUE="'.$udp_port_cnt.'">';
   echo '<INPUT TYPE="hidden" NAME="udp_field_cnt" VALUE="'.$udp_field_cnt.'">';
   echo '<INPUT TYPE="hidden" NAME="icmp_field_cnt" VALUE="'.$icmp_field_cnt.'">';
   echo '<INPUT TYPE="hidden" NAME="data_cnt" VALUE="'.$data_cnt.'">';
}

echo '<!--<INPUT TYPE="hidden" NAME="layer4" VALUE="'.$layer4.'">-->
      <INPUT TYPE="hidden" NAME="have_meta" VALUE="'.$have_meta.'">
      <INPUT TYPE="hidden" NAME="have_ip" VALUE="'.$have_ip.'">
      <INPUT TYPE="hidden" NAME="have_tcp" VALUE="'.$have_tcp.'">
      <INPUT TYPE="hidden" NAME="have_udp" VALUE="'.$have_udp.'">
      <INPUT TYPE="hidden" NAME="have_icmp" VALUE="'.$have_icmp.'">
      <INPUT TYPE="hidden" NAME="have_data" VALUE="'.$have_data.'">';
//  $db->acidClose();

  $qs->SaveState();
  $et->Mark("Get Query Elements");
  $et->PrintTiming();

  echo "\n</FORM>\n";
  
  PrintACIDSubFooter();

?>





