#! /bin/ksh
##############################################################
#	Nom    : acg_sur_seuil.sh
#	Auteur : ACGCENTER
#
#       But    : Controle de seuil de disque
#	         Code retour = taux d occupation
#
##############################################################
#
#	1 -  Chargement des fonctions
#            AFFICHAGE et SORTIE  
#	2 -  Controle pre-requis 2 argument
#	3 -  Rajout d un $ apres la variable FS
#	4 -  Type de machine
#	5 -  Traitement par machine
#
#############################################################
# Codes sortie
#
#       2 - sortie manque arg - message trop long 
#       xxx = taux d occupation + 100
#
###############################################################
# Variables globale

#	. /etc/ACGVISION.sh
DAT="/home/remi/NetBeansProjects/AgentSOAP/tmp" 
########################################



	FS="$1\$"
	export FS
	LV="$2"
	export LV
    if [ "$LV" = "" ] ; then   LV="/" && export LV ; fi

#----------------------------------------------------------------
# Traitement du type unix 

	OS=`uname`	
	export OS
#----------------------------------------------------------------
# Traitement des taux par type de machine
case $OS in
HP-UX)
	taux=`bdf | grep " $FS" | grep "$LV" |cut -d"%" -f1`
	set $taux
	let nb=$#-1
	shift $nb
	taux="$1"
	export taux
	;;
AIX)
	taux=`df -k | grep " $FS" | grep "$LV" | cut -d% -f1 | awk '{print $5}'`; export taux
	export taux
	;;
SunOS)

        FS="$1"
        export FS
        LV="$2"
        export LV
        if [ "$LV" = "" ] ; then   LV="/" && export LV ; fi

        CTR1=`mount | grep "${FS} " | awk '{print $1}'` ; export CTR1
        CTR2=`mount | grep "${FS} " | awk '{print $3}'` ; export CTR2
        taux=`df -k | grep "${CTR1}" | grep "${CTR2}" | grep " ${FS}" | cut -d% -f1 | awk '{print $5}'`; export taux
        export taux
        ;;

Linux)

	FS="$1"
        export FS
        LV="$2"
        export LV
    	if [ "$LV" = "" ] ; then   LV="/" && export LV ; fi

	CTR1=`mount | grep "${FS} " | awk '{print $1}'` ; export CTR1
	CTR2=`mount | grep "${FS} " | awk '{print $3}'` ; export CTR2
        taux=`df -P | grep "${CTR1}" | grep "${CTR2}" | grep "${FS}" | cut -d% -f1 | awk '{print $5}'`; export taux
        export taux
        ;;

SCO_SV)
	FS="$1"
        export FS
        LV="$2"
        export LV
        if [ "$LV" = "" ] ; then   LV="/" && export LV ; fi

        CTR1=`mount | grep "${FS} " | awk '{print $1}'` ; export CTR1
        CTR2=`mount | grep "${FS} " | awk '{print $3}'` ; export CTR2
        taux=`df -P | grep "${CTR1}" | grep "${CTR2}" | grep "${FS}" | cut -d% -f1 | awk '{print $5}'`; export taux
        export taux
	;;

Solaris)
	exit -1 ;;

*)		exit -1 ;;
    esac
##############################################################
# Fin de la procedure 

#-------------------------------------------------------------
# Sortie avec taux d occupation + 100
#---------------------------------------------------------------
# ACG Center 2006, modification
# du systeme de sortie pour que la premiere ligne soit la valeur
# de retour - cf historisation...
#---------------------------------------------------------------
echo $taux
exit $taux
################################### F I N ###############################
