package WB26WorkspaceCreator;

# ************************************************************
# Description   : Workbench 2.6 / VxWorks 6.4 generator
# Author        : Johnny Willemsen
# Create Date   : 07/01/2008
# ************************************************************

# ************************************************************
# Pragmas
# ************************************************************

use strict;

use WB26ProjectCreator;
use WorkspaceCreator;

use vars qw(@ISA);
@ISA = qw(WorkspaceCreator);

# ************************************************************
# Subroutine Section
# ************************************************************

sub workspace_file_name {
  #my($self) = shift;
  return 'org.eclipse.core.resources.prefs';
}

sub pre_workspace {
  my($self) = shift;
  my($fh)   = shift;
  my($crlf) = $self->crlf();

  print $fh '#----------------------------------------------------------------------------', $crlf,
            '#       WindRiver Workbench generator', $crlf,
            '#', $crlf,
            '# $Id: WB26WorkspaceCreator.pm 1264 2008-01-24 16:01:40Z johnnyw $', $crlf,
            '#', $crlf,
            '# This file was generated by MPC.  Any changes made directly to', $crlf,
            '# this file will be lost the next time it is generated.', $crlf,
            '# This file should be placed in the .metadata\.plugins\org.eclipse.core.runtime\.settings directory', $crlf,
            '#', $crlf,
            '# MPC Command:', $crlf,
            "# $0 @ARGV", $crlf,
            '#----------------------------------------------------------------------------', $crlf,
            'version=1', $crlf,
            'eclipse.preferences.version=1', $crlf,
            'description.defaultbuildorder=false', $crlf;
}

sub write_comps {
  my($self)     = shift;
  my($fh)       = shift;
  my($projects) = $self->get_projects();
  my($pjs)      = $self->get_project_info();
  my(%targnum)  = ();
  my(@list)     = $self->number_target_deps($projects, $pjs, \%targnum, 0);
  my($crlf)     = $self->crlf();
  my($all)      = 'description.buildorder=';

  ## Construct the target
  foreach my $project (@list) {
    $all .= "$$pjs{$project}->[0]/";
  }
  print $fh $all, $crlf;
}

1;
