// -*- C++ -*-

//=============================================================================
/**
 *  @file    Home_Servant_Impl_Base.h
 *
 *  Home_Servant_Impl_Base.h,v 1.2 2004/09/27 22:43:31 bala Exp
 *
 *  This file contains the non-template declaration of a base class for
 *  the template mixin for the generated home servant class.
 *
 *  @author Jeff Parsons <j.parsons@vanderbilt.edu>
 */
//=============================================================================


#ifndef CIAO_HOME_SERVANT_IMPL_BASE_H
#define CIAO_HOME_SERVANT_IMPL_BASE_H

#include /**/ "ace/pre.h"

#include "CCM_ComponentS.h"

#if !defined (ACE_LACKS_PRAGMA_ONCE)
# pragma once
#endif /* ACE_LACKS_PRAGMA_ONCE */

#include "CIAO_Server_Export.h"

namespace CIAO
{
  class Session_Container;

  /**
   * @class Home_Servant_Impl_Base
   *
   * @brief Non-template base class for Home_Servant_Impl.
   *
   * Holds the non-template parts of its child class
   * Home_Servant_Impl.
   */
  class CIAO_SERVER_Export Home_Servant_Impl_Base
    : public virtual POA_Components::CCMHome
  {
  public:
    explicit Home_Servant_Impl_Base (void);

    Home_Servant_Impl_Base (Session_Container * c);

    virtual ~Home_Servant_Impl_Base (void);

    // Operations for CCMHome interface.

    virtual ::CORBA::IRObject_ptr
    get_component_def (ACE_ENV_SINGLE_ARG_DECL_WITH_DEFAULTS)
      ACE_THROW_SPEC ((CORBA::SystemException));

    virtual ::CORBA::IRObject_ptr
    get_home_def (ACE_ENV_SINGLE_ARG_DECL_WITH_DEFAULTS)
      ACE_THROW_SPEC ((CORBA::SystemException));

  protected:
    Session_Container *container_;
  };
}

#include /**/ "ace/post.h"

#endif /* CIAO_HOME_SERVANT_IMPL_BASE_H */
