/* AbiWord
 * Copyright (C) 1998 AbiSource, Inc.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
 * 02111-1307, USA.
 */

#ifdef ABI_PLUGIN_BUILTIN
#define abi_plugin_register abipgn_docbook_register
#define abi_plugin_unregister abipgn_docbook_unregister
#define abi_plugin_supports_version abipgn_docbook_supports_version
#endif

#include "ie_imp_DocBook.h"
#include "ie_exp_DocBook.h"
#include "xap_Module.h"

ABI_PLUGIN_DECLARE("DocBook")

#define PLUGIN_NAME "AbiDocBook::DocBook"

// we use a reference-counted sniffer
static IE_Imp_DocBook_Sniffer * m_impSniffer = 0;
static IE_Exp_DocBook_Sniffer * m_expSniffer = 0;

extern int docbook_coquille_register ();
extern int docbook_coquille_unregister ();

ABI_FAR_CALL
int abi_plugin_register (XAP_ModuleInfo * mi)
{
	if (!m_impSniffer)
	{
		m_impSniffer = new IE_Imp_DocBook_Sniffer (PLUGIN_NAME);
	}
	else
	{
		m_impSniffer->ref();
	}

	if (!m_expSniffer)
	{
		m_expSniffer = new IE_Exp_DocBook_Sniffer (PLUGIN_NAME);
	}
	else
	{
		m_expSniffer->ref();
	}
	IE_Imp::registerImporter (m_impSniffer);
	IE_Exp::registerExporter (m_expSniffer);

#ifndef DOCBOOK_COQUILLE
	mi->name = "DocBook Importer/Exporter";
	mi->desc = "Import/Export DocBook Documents";
	mi->version = ABI_VERSION_STRING;
	mi->author = "Abi the Ant";
	mi->usage = "No Usage";
#else
	mi->name = "DocBook/Coquille Importer/Exporter";
	mi->desc = "Import/Export DocBook Documents, with Coquille header extensions";
	mi->version = ABI_VERSION_STRING;
	mi->author = "Abi the Ant, and Nicolas MERCIER <linux@infobi.com> / Infobi";
	mi->usage = "No Usage";

	docbook_coquille_register ();
#endif
	return 1;
}

ABI_FAR_CALL
int abi_plugin_unregister (XAP_ModuleInfo * mi)
{
#ifdef DOCBOOK_COQUILLE
	docbook_coquille_unregister ();
#endif
	mi->name = 0;
	mi->desc = 0;
	mi->version = 0;
	mi->author = 0;
	mi->usage = 0;

	UT_ASSERT (m_impSniffer);
	UT_ASSERT (m_expSniffer);

	IE_Imp::unregisterImporter (m_impSniffer);
	if (!m_impSniffer->unref())
	{
		m_impSniffer = 0;
	}

	IE_Exp::unregisterExporter (m_expSniffer);
	if (!m_expSniffer->unref())
	{
		m_expSniffer = 0;
	}

	return 1;
}

ABI_FAR_CALL
int abi_plugin_supports_version (UT_uint32 major, UT_uint32 minor, 
								 UT_uint32 release)
{
  return 1;
}
